\name{prostate}
\alias{prostate}
\title{Factors associated with prostate specific antigen}
\description{The \code{prostate} data frame contains 97 men (rows) and 9
  variables (columns).  The data come from a study by Stamey et al. to
  examine the association between prostate specific antigen (PSA) and
  several clinical measures that are potentially associated with PSA in
  men who were about to receive a radical prostatectomy.}
\usage{data(prostate)}
\format{This data frame contains the following columns:
  \describe{
    \item{lcavol}{Log cancer volume}
    \item{lweight}{Log prostate weight}
    \item{age}{The man's age}
    \item{lbph}{Log of the amount of benign hyperplasia}
    \item{svi}{Seminal vesicle invasion: 1=Yes, 0=No}
    \item{lcp}{Log of capsular penetration}
    \item{gleason}{Gleason score}
    \item{pgg45}{Percent of Gleason scores 4 or 5}
    \item{lpsa}{Log PSA}}}
\source{http://www-stat-class.stanford.edu/~tibs/ElemStatLearn/}
\references{
  Hastie, T., Tibshirani, R., and Friedman, J. (2001). \emph{The
    Elements of Statistical Learning}.  Springer.\cr
  Stamey, T., et al. (1989).  Prostate specific antigen in the
  diagnosis and treatment of adenocarcinoma of the prostate. II. Radical
  prostatectomy treated patients. \emph{Journal of Urology}: 16:
  1076-1083. \cr}
\keyword{datasets}
