% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.cat.R
\name{neg.cat}
\alias{neg.cat}
\alias{print.neg.cat}
\title{Equivalence Testing for Categorical Variables}
\usage{
neg.cat(
  v1 = NULL,
  v2 = NULL,
  tab = NULL,
  eiU = 0.2,
  data = NULL,
  plot = TRUE,
  save = FALSE,
  nbootpd = 1000,
  alpha = 0.05
)

\method{print}{neg.cat}(x, ...)
}
\arguments{
\item{v1}{first categorical variable}

\item{v2}{second categorical variable}

\item{tab}{contingency table for the two predictor variables}

\item{eiU}{upper limit of equivalence interval}

\item{data}{data file containing the categorical variables}

\item{plot}{should a plot be printed out with the effect and the proportional distance}

\item{save}{should the plot be saved to 'jpg' or 'png'}

\item{nbootpd}{number of bootstrap samples for calcuating the CI for the proportional distance}

\item{alpha}{nominal acceptable Type I error rate level}

\item{x}{Data frame from neg.cat}

\item{...}{extra arguments}
}
\value{
returns a \code{list} containing each analysis and their respective statistics
  and decision


}
\description{
Testing for the presence of a negligible association between two categorical variables
}
\examples{
sex<-rep(c("m","f"),c(12,22))
haircol<-rep(c("bld","brn","bld","brn"),c(9,7,11,7))
d <- data.frame(sex,haircol)
tab<-table(sex,haircol)
neg.cat(tab=tab, alpha=.05, nbootpd=50)
neg.cat(v1=sex, v2=haircol, data=d, nbootpd=50)
}
