% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.esm.R
\name{neg.esm}
\alias{neg.esm}
\alias{print.neg.esm}
\title{Test for Evaluating Substantial Mediation}
\usage{
neg.esm(
  X,
  Y,
  M,
  alpha = 0.05,
  minc = 0.15,
  eil = -0.15,
  eiu = 0.15,
  nboot = 1000L,
  data = NULL,
  plot = TRUE,
  saveplot = FALSE,
  seed = NA
)

\method{print}{neg.esm}(x, ...)
}
\arguments{
\item{X}{predictor variable}

\item{Y}{outcome variable}

\item{M}{mediator variable}

\item{alpha}{alpha level (default = .05)}

\item{minc}{minimum correlation between x and Y (default is .15)}

\item{eil}{lower bound of equivalence interval in standardized units(default is -.15)}

\item{eiu}{upper bound of equivalence interval in standardized units (default is .15)}

\item{nboot}{number of bootstraps (default = 500L)}

\item{data}{optional data argument}

\item{plot}{logical, plotting the results (default = TRUE)}

\item{saveplot}{saving plots (default = FALSE)}

\item{seed}{optional argument to set seed}

\item{x}{object of class \code{neg.esm}}

\item{...}{extra arguments}
}
\value{
A \code{list} including the following:
\itemize{
  \item \code{minc} Minimum correlation between X and Y for a valid negligible effect (equivalence) test
  \item \code{corxy} Sample correlation between the IV (X) and DV (Y)
  \item \code{dir_eff} Sample standardized direct effect between the IV (X) and DV (Y) after controlling for the mediator (M)
  \item \code{eiL} Lower bound of the negligible effect (equivalence) interval
  \item \code{eiU} Upper bound of the negligible effect (equivalence) interval
  \item \code{cil} Lower bound of the 1-2*alpha CI for the standardized direct effect of X on Y
  \item \code{ciu} Upper bound of the 1-2*alpha CI for the standardized direct effect of X on Y
  \item \code{PD} Proportional distance (PD)
  \item \code{cilpd} Lower bound of the 1-alpha CI for the PD
  \item \code{ciupd} Upper bound of the 1-alpha CI for the PD
  \item \code{ab_par} Standardized indirect effect
  \item \code{abdivc_k} Proportion mediated: Standardized indirect effect divided by the standardized total effect
  \item \code{alpha} Nominal Type I error rate
}
}
\description{
Function computes the equivalence testing method (total effect) for evaluating substantial mediation and Kenny method for full mediation.
}
\details{
This function evaluates whether a negligible direct effect of X on Y exists after controlling for the mediator. Another way to word this is that the indirect effect accounts for a substantial proportion of the variability in X-Y relationship. See Beribisky, Mara, and Cribbie (https://doi.org/10.20982/tqmp.16.4.p424)

The user specifies the IV (X), DV (Y) and mediator (M). The user can also specify the alpha level, the lower/upper bound of the negligible effect interval (eiL, eiU), the number of bootstrap samples (nboot), as well as the minimum correlation between X and Y that is permitted for a valid test of substantial mediation.

The variables X, Y and M can be specified as stand-alone, or a data argument can be used if the data reside in an R dataset.

For the Kenny method see: https://davidakenny.net/cm/mediate.htm

The proportional distance quantifies the proportional distance from 0 to the nearest negligible effect (equivalence) interval (eiL, eiU). As values get farther from 0 the relationship becomes more substantial, with values greater than 1 indicating that the effect falls outside of the negligible effect (equivalence) interval.

Note that the number of bootstrap samples (nboot) are low for the example since the example has a time limit of 5 seconds to pass CRAN testing; we recommend running a much higher number of bootstrap samples for analyses.
}
\examples{
#equivalence test for substantial mediation
#with an equivalence interval of -.15 to .15
d <- negligible::perfectionism
neg.esm(X = atqpre.total,Y = cesdpost.total,M = baipre.total,
  eil = -.15, eiu = .15,nboot = 5, data = d)
}
\author{
Rob Cribbie \email{cribbie@yorku.ca} and
  Nataly Beribisky \email{natalyb1@yorku.ca}
}
