% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/respiratory_02_population.R
\name{respiratory_02_population}
\alias{respiratory_02_population}
\title{Respiratory-02 Populations}
\usage{
respiratory_02_population(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  vitals_table = NULL,
  medications_table = NULL,
  procedures_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  evitals_12_col,
  emedications_03_col,
  eprocedures_03_col
)
}
\arguments{
\item{df}{A data frame containing incident data with each row representing an
observation.}

\item{patient_scene_table}{A data.frame or tibble containing at least
epatient and escene fields as a fact table.}

\item{response_table}{A data.frame or tibble containing at least the
eresponse fields needed for this measure's calculations.}

\item{vitals_table}{A data.frame or tibble containing at least the evitals
fields needed for this measure's calculations.}

\item{medications_table}{A data.frame or tibble containing only the
emedications fields needed for this measure's calculations.}

\item{procedures_table}{A data.frame or tibble containing only the
eprocedures fields needed for this measure's calculations.}

\item{erecord_01_col}{Column name for eRecord.01, used to form a unique
patient ID.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{integer Column giving the calculated age value.}

\item{epatient_16_col}{Column giving the provided age unit value.}

\item{eresponse_05_col}{Column name for response codes (e.g., incident type).}

\item{evitals_12_col}{Column name for oxygen saturation (SpO2) values.}

\item{emedications_03_col}{Column name for medication codes.}

\item{eprocedures_03_col}{Column name for procedure codes.}
}
\value{
A list that contains the following:
\itemize{
\item a tibble with counts for each filtering step,
\item a tibble for each population of interest
\item a tibble for the initial population
\item a tibble for the total dataset with computations
}
}
\description{
The \code{respiratory_02_population} function calculates metrics for pediatric and
adult respiratory populations based on pre-defined criteria, such as low
oxygen saturation and specific medication or procedure codes. It returns a
summary table of the overall, pediatric, and adult populations, showing
counts and proportions.
}
\examples{
# create tables to test correct functioning
# patient table
  patient_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    incident_date = as.Date(c("2025-01-01", "2025-01-05",
                              "2025-02-01", "2025-01-01",
                              "2025-06-01")
                              ),
    patient_dob = as.Date(c("2000-01-01", "2020-01-01",
                            "2023-02-01", "2023-01-01",
                            "1970-06-01")
                            ),
    epatient_15 = c(25, 5, 2, 2, 55),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Years", "Years")

  )

  # response table
  response_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    eresponse_05 = rep(2205001, 5)

  )

  # medications table
  medications_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    emedications_03 = c("Oxygen", "Oxygen", "Oxygen", "Oxygen", "Oxygen")

  )

  # vitals table
  vitals_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    evitals_12 = c(60, 59, 58, 57, 56),

  )

  # procedures table
  procedures_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    eprocedures_03 = rep("applicable thing", 5)

  )

# Run the function
result <- respiratory_02_population(patient_scene_table = patient_table,
                              response_table = response_table,
                              medications_table = medications_table,
                              vitals_table = vitals_table,
                              procedures_table = procedures_table,
                              erecord_01_col = erecord_01,
                              incident_date_col = incident_date,
                              patient_DOB_col = patient_dob,
                              epatient_15_col = epatient_15,
                              epatient_16_col = epatient_16,
                              eresponse_05_col = eresponse_05,
                              emedications_03_col = emedications_03,
                              evitals_12_col = evitals_12,
                              eprocedures_03_col = eprocedures_03
                             )

# show the results of filtering at each step
result$filter_process

}
\author{
Nicolas Foss, Ed.D., MS
}
