% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trauma_01.R
\name{trauma_01}
\alias{trauma_01}
\title{Trauma-01 Calculation}
\usage{
trauma_01(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  disposition_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  esituation_02_col,
  eresponse_05_col,
  evitals_23_col,
  evitals_26_col,
  evitals_27_col,
  edisposition_28_col,
  transport_disposition_col,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing EMS records. Default is \code{NULL}.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data.frame or tibble containing only the esituation
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{disposition_table}{A data.frame or tibble containing only the
edisposition fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{vitals_table}{A data.frame or tibble containing only the evitals fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{Column name representing the EMS record ID.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column name for the patient's age in numeric format.}

\item{epatient_16_col}{Column name for the unit of age (e.g., "Years",
"Months").}

\item{esituation_02_col}{Column name indicating if the situation involved an
injury.}

\item{eresponse_05_col}{Column name for the type of EMS response (e.g., 911
call).}

\item{evitals_23_col}{Column name for the Glasgow Coma Scale (GCS) total
score.}

\item{evitals_26_col}{Column name for AVPU (Alert, Voice, Pain, Unresponsive)
status.}

\item{evitals_27_col}{Column name for the pain scale assessment.}

\item{edisposition_28_col}{Column name for patient care disposition details.}

\item{transport_disposition_col}{Column name for transport disposition
details.}

\item{...}{Additional arguments passed to the \code{dplyr::summarize} function for
custom summarization.}
}
\value{
A tibble summarizing results for three population groups (All,
Adults, and Peds) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (All, Adults, Peds).
\code{numerator}: Count of incidents where a pain scale was administered.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of incidents where a pain scale was administered.
\code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
}
\description{
This function processes EMS data to calculate the Trauma-01 performance
measure, which evaluates the percentage of trauma patients assessed for pain
using a numeric scale. The function filters and summarizes the data based on
specified inclusion criteria.
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    esituation_02 = rep("Yes", 5),
    evitals_23 = rep(15, 5),
    evitals_26 = rep("Alert", 5),
    evitals_27 = c(0, 2, 4, 6, 8),
    edisposition_28 = rep(4228001, 5),
    edisposition_30 = c(4230001, 4230003, 4230001, 4230007, 4230007)
  )

  # Run function
  trauma_01(
    df = test_data,
    erecord_01_col = erecord_01,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    esituation_02_col = esituation_02,
    evitals_23_col = evitals_23,
    evitals_26_col = evitals_26,
    evitals_27_col = evitals_27,
    edisposition_28_col = edisposition_28,
    transport_disposition_col = edisposition_30
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
