% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadByProduct.R
\name{loadByProduct}
\alias{loadByProduct}
\title{Get files from NEON API, stack tables, and load into the current environment}
\usage{
loadByProduct(dpID, site = "all", package = "basic", avg = "all",
  check.size = TRUE)
}
\arguments{
\item{dpID}{The identifier of the NEON data product to pull, in the form DPL.PRNUM.REV, e.g. DP1.10023.001}

\item{site}{Either the string 'all', or the four-letter code of a single NEON site, e.g. 'CLBJ'. Future versions may allow more options for subsetting than one or all sites. Defaults to all.}

\item{package}{Either 'basic' or 'expanded', indicating which data package to download. Defaults to basic.}

\item{avg}{Either the string 'all', or the averaging interval to download, in minutes. Only applicable to sensor (IS) data. Defaults to 'all'.}

\item{check.size}{T or F, should the user be told the total file size before downloading? Defaults to T. When working in batch mode, or other non-interactive workflow, use check.size=F.}
}
\value{
A named list of all the data tables in the data product downloaded, plus a validation file and a variables file, as available.
}
\description{
Pull files from the NEON API, by data product, merge data for each table, and read into the current R environment
}
\examples{
\dontrun{
# To download plant foliar properties data from all sites, expanded data package:
cfc <- loadByProduct(dpID="DP1.10026.001", site="all", package="expanded")
}
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Claire Lunch \email{clunch@battelleecology.org}
}
