% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stats.R
\name{get_stats}
\alias{get_stats}
\title{get_stats}
\usage{
get_stats(start = 0, end = 1, type = "dsdbmonth")
}
\arguments{
\item{start}{The starting month (from present == 0) for
which to generate the summary. Default is 0 (the current month).}

\item{end}{The ending month (from present == 0) for which
to generate the summary. Default is 1 (one month ago).}

\item{type}{A character string indicating the type of summary
to return. Options are \code{dsdbmonth} (the number of datasets
in the Neotoma Database added per month), \code{rawbymonth} (the
number of datasets, sites, publications, authors, countries and observations
added per month), and \code{dstypemonth} (the number of datasets added
per dataset type per month). Default is \code{dsdbmonth}.}
}
\value{
\code{data.frame} with summary statistics
}
\description{
Returns a count of sites, datasets, publications and other
objects added to Neotoma during the requested time period.
}
\details{
This function returns summaries about the data holdings
within Neotoma using the existing Neotoma API's \code{summary} endpoint. This can
provide information about recent uploads (the number of new sites
uploaded within the last month, for example), or can be used to provide
information about the overall number of sites/datasets (using an arbitrarily
high value for \code{end}).
}
\examples{
\donttest{
tryCatch({
last_month <- get_stats(start = 0, end = 1, type = "dsdbmonth")
}, error = function(e) {
 message("Neotoma server not responding. Try again later.")
})
}
}
\author{
Socorro Dominguez \email{dominguezvid@wisc.edu}

Simon Goring \email{goring@wisc.edu}
}
