% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nestedMethods.R
\name{nestedMethods}
\alias{nestedMethods}
\alias{print.nestedLogit}
\alias{summary.nestedLogit}
\alias{print.summary.nestedLogit}
\alias{update.nestedLogit}
\alias{predict.nestedLogit}
\alias{coef.nestedLogit}
\alias{vcov.nestedLogit}
\alias{print.dichotomies}
\alias{as.dichotomies.matrix}
\alias{as.matrix.continuationDichotomies}
\alias{as.character.dichotomies}
\alias{as.matrix.dichotomies}
\alias{print.predictDichotomies}
\alias{fitted.nestedLogit}
\alias{as.dichotomies}
\title{Methods for \code{"nestedLogit"} and Related Objects}
\usage{
\method{print}{nestedLogit}(x, ...)

\method{summary}{nestedLogit}(object, ...)

\method{print}{summary.nestedLogit}(x, ...)

\method{print}{dichotomies}(x, ...)

\method{predict}{nestedLogit}(object, newdata, model = c("nested", "dichotomies"), ...)

\method{print}{predictDichotomies}(x, ...)

\method{fitted}{nestedLogit}(object, model = c("nested", "dichotomies"), ...)

\method{coef}{nestedLogit}(object, as.matrix = TRUE, ...)

\method{vcov}{nestedLogit}(object, as.matrix = FALSE, ...)

\method{update}{nestedLogit}(object, formula, dichotomies, data, subset, contrasts, ...)

\method{as.matrix}{dichotomies}(x, ...)

\method{as.character}{dichotomies}(x, ...)

\method{as.matrix}{continuationDichotomies}(x, ...)

as.dichotomies(x, ...)

\method{as.dichotomies}{matrix}(x, ...)
}
\arguments{
\item{x, object}{in most cases, an object of class \code{"nestedLogit"}.}

\item{\dots}{arguments to be passed down.}

\item{newdata}{For the \code{predict} method, a data frame containing combinations of values of the predictors
at which fitted probabilities (or other quantities) are to be computed.}

\item{model}{For the \code{predict} and \code{fitted} methods, either \code{"nested"} (the default), in which case fitted probabilities
under the nested logit model are returned, or \code{"dichotomies"}, in which case
\code{\link{predict.glm}} is invoked for each binary logit model fit to the nested
dichotomies and a named list of the results is returned.}

\item{as.matrix}{if \code{TRUE} (the default for \code{coef}) return coefficients
as a matrix with one column for each nested dichotomy,
or coefficient covariances as a matrix with one row and column for each
combination of dichotomies and coefficients; if \code{FALSE} (the default for
\code{vcov}), return a list of coefficients or coefficient covariances
with one element for each dichotomy.}

\item{formula}{optional updated model formula.}

\item{dichotomies}{optional updated dichotomies object.}

\item{data}{optional updated data argument}

\item{subset}{optional updated subset argument.}

\item{contrasts}{optional updated contrasts argument.}
}
\value{
\itemize{
\item The \code{coef} and \code{vcov} methods return either matrices or lists of regression
coefficients and their covariances, respectively.
\item The \code{update} method returns an object of class \code{"nestedLogit"} (see \code{\link{nestedLogit}})
derived from the original nested-logit model.
\item The \code{predict} and \code{fitted} methods return either a matrix of predicted probabilities or an
object of class \code{"predictDichotomies"}, which is a named list with predicted logits for
each nested-dichotomy model.
\item The \code{glance} and \code{tidy} methods return 'tibbles' containing model summaries.
\item The \code{summary} method returns an object of class \code{"summary.nestedLogit"}, which is
a list of summaries of the \code{\link{glm}} objects that comprise the nested-dichotomies model; the
object is normally printed.
\item The methods for \code{as.matrix}, \code{as.character}, and \code{as.dichotomies} coerce
various objects to matrices, character vectors, and dichotomies objects.
\item The various \code{print} methods invisibly return their \code{x} arguments.
}
}
\description{
Various methods for processing \code{"nestedLogit"} and related objects.
Most of these are the standard methods for a model-fitting function.
\describe{
\item{\code{coef}, \code{vcov}}{Return the coefficients and their variance-covariance matrix respectively.}
\item{\code{update}}{Re-fit a \code{"nestedLogit"} model with a change in any of the \code{formula}, \code{dichotomies},
\code{data}, \code{subset}, or \code{contrasts}, arguments.}
\item{\code{predict}, \code{fitted}}{Computes predicted values from a fitted \code{"nestedLogit"} model.}
\item{\code{glance}}{Construct a single row summaries for the dichotomies \code{"nestedLogit"} model.}
\item{\code{tidy}}{Summarizes the terms in \code{"nestedLogit"} model.}
}
}
\details{
The \code{predict} method provides predicted values for two representations of the model.
\code{model = "nested"} gives the fitted probabilities for each of the response categories.
\code{model = "dichotomies"} gives the fitted log odds for each binary logit models in the
dichotomies.
}
\examples{
# define continuation dichotomies for level of education
cont.dichots <- continuationLogits(c("l.t.highschool",
                                     "highschool",
                                     "college",
                                     "graduate"))

# Show dichotomies in various forms
print(cont.dichots)
as.matrix(cont.dichots)
as.character(cont.dichots)

# fit a nested model for the GSS data examining education degree in relation to parent & year
m <- nestedLogit(degree ~ parentdeg + year,
                 cont.dichots,
                 data=GSS)

coef(m)                             # coefficient estimates
sqrt(diag(vcov(m, as.matrix=TRUE))) # standard errors
print(m)
summary(m)

# broom methods
broom::glance(m)
broom::tidy(m)

# predicted probabilities and ploting
head(predict(m)) # fitted probabilities for first few cases; 
                 # equivalent to head(fitted(m))
new <- expand.grid(parentdeg=c("l.t.highschool",  "highschool",
                               "college", "graduate"),
                   year=c(1972, 2016))
fit <- predict(m, newdata=new)
cbind(new, fit) # fitted probabilities at specific values of predictors

# predicted logits
predictions <- predict(m, newdata=new, model="dichotomies", se.fit=TRUE)
predictions
predictions$above_l.t.highschool # on logit scale

}
\seealso{
\code{\link{nestedLogit}}, \code{\link{plot.nestedLogit}},
\code{\link{glance.nestedLogit}}, \code{\link{tidy.nestedLogit}}
}
\author{
John Fox and Michael Friendly
}
\keyword{regression}
