% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nestcv_SuperLearner.R
\name{nestcv.SuperLearner}
\alias{nestcv.SuperLearner}
\title{Outer cross-validation of SuperLearner model}
\usage{
nestcv.SuperLearner(
  y,
  x,
  filterFUN = NULL,
  filter_options = NULL,
  weights = NULL,
  balance = NULL,
  balance_options = NULL,
  outer_method = c("cv", "LOOCV"),
  n_outer_folds = 10,
  outer_folds = NULL,
  cv.cores = 1,
  na.option = "pass",
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Dataframe or matrix of predictors. Matrix will be coerced to
dataframe as this is the default for SuperLearner.}

\item{filterFUN}{Filter function, e.g. \link{ttest_filter} or \link{relieff_filter}.
Any function can be provided and is passed \code{y} and \code{x}. Must return a
character vector with names of filtered predictors. Not available if
\code{outercv} is called with a formula.}

\item{filter_options}{List of additional arguments passed to the filter
function specified by \code{filterFUN}.}

\item{weights}{Weights applied to each sample for models which can use
weights. Note \code{weights} and \code{balance} cannot be used at the same time.
Weights are not applied in filters.}

\item{balance}{Specifies method for dealing with imbalanced class data.
Current options are \code{"randomsample"} or \code{"smote"}. Not available if
\code{outercv} is called with a formula. See \code{\link[=randomsample]{randomsample()}} and \code{\link[=smote]{smote()}}}

\item{balance_options}{List of additional arguments passed to the balancing
function}

\item{outer_method}{String of either \code{"cv"} or \code{"LOOCV"} specifying whether
to do k-fold CV or leave one out CV (LOOCV) for the outer folds}

\item{n_outer_folds}{Number of outer CV folds}

\item{outer_folds}{Optional list containing indices of test folds for outer
CV. If supplied, \code{n_outer_folds} is ignored.}

\item{cv.cores}{Number of cores for parallel processing of the outer loops.
NOTE: this uses \code{parallel::mclapply} on unix/mac and \code{parallel::parLapply}
on windows.}

\item{na.option}{Character value specifying how \code{NA}s are dealt with.
\code{"omit"} is equivalent to \code{na.action = na.omit}. \code{"omitcol"} removes cases
if there are \code{NA} in 'y', but columns (predictors) containing \code{NA} are
removed from 'x' to preserve cases. Any other value means that \code{NA} are
ignored (a message is given).}

\item{...}{Additional arguments passed to \code{\link[SuperLearner:SuperLearner]{SuperLearner::SuperLearner()}}}
}
\value{
An object with S3 class "nestcv.SuperLearner"
\item{call}{the matched call}
\item{output}{Predictions on the left-out outer folds}
\item{outer_result}{List object of results from each outer fold containing
predictions on left-out outer folds, model result and number of filtered
predictors at each fold.}
\item{dimx}{vector of number of observations and number of predictors}
\item{y}{original response vector}
\item{yfinal}{final response vector (post-balancing)}
\item{outer_folds}{List of indices of outer test folds}
\item{final_fit}{Final fitted model on whole data}
\item{final_vars}{Column names of filtered predictors entering final model}
\item{summary_vars}{Summary statistics of filtered predictors}
\item{roc}{ROC AUC for binary classification where available.}
\item{summary}{Overall performance summary. Accuracy and balanced accuracy
for classification. ROC AUC for binary classification. RMSE for
regression.}
}
\description{
Provides a single loop of outer cross-validation to evaluate performance of
ensemble models from \code{SuperLearner} package.
}
\details{
This performs an outer CV on SuperLearner package ensemble models to measure
performance, allowing balancing of imbalanced datasets as well as filtering
of predictors. SuperLearner prefers dataframes as inputs for the predictors.
If \code{x} is a matrix it will be coerced to a dataframe and variable names
adjusted by \code{\link[=make.names]{make.names()}}.
}
\note{
Care should be taken with some \code{SuperLearner} models e.g. \code{SL.gbm} as some
models have multicore enabled by default, which can lead to huge numbers of
processes being spawned.
}
\seealso{
\code{\link[SuperLearner:SuperLearner]{SuperLearner::SuperLearner()}}
}
