% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stir_SW.R
\name{stir_SW}
\alias{stir_SW}
\title{Stirs a Small-World Network}
\usage{
stir_SW(matrix, x, rewire, directed = TRUE)
}
\arguments{
\item{matrix}{Existing network to experience growth.}

\item{x}{The ID of the node to be grown.}

\item{rewire}{Small-World parameter specifying the probability each edge is randomly rewired, allowing for the possiblity of bridges between connected communities.}

\item{directed}{Binary variable determining if the network is directed, resulting in off-diagonal asymmetry in the adjacency matrix.}
}
\value{
An adjacency matrix.
}
\description{
Stirs an already existing network by rewiring a node according to the Small-World mechanism.
}
\details{
Rewires a node in a network according to the Small-World mechanism.
}
\examples{
# Import netcom
library(netcom)

size <- 10
existing_network <- matrix(sample(c(0,1), size = size^2, replace = TRUE), nrow = size, ncol = size)
new_network_prep <- matrix(0, nrow = size + 1, ncol = size + 1)
new_network_prep[1:size, 1:size] = existing_network
new_network <- stir_SW(matrix = new_network_prep, x = size + 1, rewire = 0.213)

}
\references{
Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of ‘small-world’networks. nature, 393(6684), 440-442.
}
