% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diffnet2.r
\name{plot_diffnet2}
\alias{plot_diffnet2}
\alias{plot_diffnet2.diffnet}
\alias{plot_diffnet2.default}
\title{Another way of visualizing diffusion}
\usage{
plot_diffnet2(graph, ...)

\method{plot_diffnet2}{diffnet}(graph, toa, slice = nslices(graph), ...)

\method{plot_diffnet2}{default}(graph, toa, pers = min(toa, na.rm =
  TRUE):max(toa, na.rm = TRUE),
  color.ramp = grDevices::colorRamp(viridisLite::magma(20)),
  layout = NULL, key.width = 0.1, key.args = list(),
  main = "Diffusion dynamics", add.map = NULL,
  diffmap.args = list(kde2d.args = list(n = 100)), diffmap.alpha = 0.5,
  include.white = "first", vertex.size = "degree",
  minmax.relative.size = getOption("diffnet.minmax.relative.size",
  c(0.01, 0.04)), no.graph = FALSE, ...)
}
\arguments{
\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}

\item{...}{Further arguments passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{toa}{Integer vector of length \eqn{n} with the times of adoption.}

\item{slice}{Integer scalar. Number of slice to use as baseline for drawing the graph.}

\item{pers}{Integer vector of length \eqn{T} indicating the time periods of the data.}

\item{color.ramp}{A function as returned by \code{\link[grDevices:colorRamp]{colorRamp}}.}

\item{layout}{Passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}

\item{key.width}{Numeric scalar. Sets the proportion of the plot (x-axis) that the key uses.}

\item{key.args}{List. Further arguments to be passed to \code{\link{drawColorKey}}.}

\item{main}{Character scalar. Title of the graph.}

\item{add.map}{Character scalar. When \code{"first"} plots a \code{\link{diffusionMap}} before the
graph itself. If \code{"last"} then it adds it at the end. When \code{NULL} adds nothing.}

\item{diffmap.args}{List. If \code{add.map=TRUE}, arguments passed to \code{diffusionMap}.}

\item{diffmap.alpha}{Numeric scalar between [0,1]. Alpha level for the map.}

\item{include.white}{Character scalar. Includes white in the color palette used in the map.
When \code{include.white=NULL} then it won't include it.}

\item{vertex.size}{Either a numeric scalar or vector of size \eqn{n}, or any
of the following values: "indegree", "degree", or "outdegree" (see details).}

\item{minmax.relative.size}{Passed to \code{\link{rescale_vertex_igraph}}.}

\item{no.graph}{Logical scala. When \code{TRUE} the graph is not drawn. This only makes
sense when the option \code{add.map} is active.}
}
\value{
A list with the following elements
\item{layout}{A numeric matrix with vertex coordinates.}
\item{vertex.color}{A character vector with computed colors for each vertex.}
\item{vertex.label}{The value passed to \code{plot_diffnet2}.}
\item{vertex.shape}{A character vector with assigned shapes.}
\item{vertex.size}{A numeric vector with vertices sizes}
\item{diffmap}{If \code{add.map=TRUE}, the returned values from \code{\link{diffmap}}}
}
\description{
Another way of visualizing diffusion
}
\details{
Plotting is done via the function \code{\link[igraph:plot.igraph]{plot.igraph}}.

When \code{vertex.size} is either of \code{"degree"}, \code{"indegree"}, or
\code{"outdegree"}, \code{vertex.size} will be replace with \code{dgr(.,cmode = )}
so that the vertex size reflects the desired degree.

The argument \code{minmax.relative.size} is passed to \code{\link{rescale_vertex_igraph}}
which adjusts \code{vertex.size} so that the largest and smallest vertices
have a relative size of \code{minmax.relative.size[2]} and
\code{minmax.relative.size[1]} respectively with respect to the x-axis.

If \code{key.width<=0} then no key is created.

By defult, the function passes the following values to \code{plot.igraph}:

\itemize{
\item{\code{vertex.label} equals to \code{""}}
\item{\code{vertex.frame.color} equals to \code{"white"}}
\item{\code{add} equals to \code{TRUE}}
\item{\code{rescale} equals to \code{FALSE}}
\item{\code{vertex.size} equals to \code{rescale.fun(vertex.size)}}
}
}
\seealso{
Other visualizations: \code{\link{dgr}},
  \code{\link{diffusionMap}}, \code{\link{drawColorKey}},
  \code{\link{grid_distribution}},
  \code{\link{hazard_rate}}, \code{\link{plot_adopters}},
  \code{\link{plot_diffnet}},
  \code{\link{plot_infectsuscep}},
  \code{\link{plot_threshold}},
  \code{\link{rescale_vertex_igraph}}
}
\author{
George G. Vega Yon
}
\concept{visualizations}
