% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_apply.R
\name{diff_test_ggPlot}
\alias{diff_test_ggPlot}
\title{Difference Test Plots}
\usage{
diff_test_ggPlot(netSampleStatSet, labels, sort = "alpha",
  p.threshold = 0.05, p.adjust = "BY", hide.non.sig = F,
  non.parametric = F)
}
\arguments{
\item{netSampleStatSet}{Input \code{NetSampleStatSet}}

\item{labels}{ggplot2 labs object. Labels for the plot}

\item{sort}{one of "alpha", "mean", "median". "alpha" sorts in alpha numeric order, while mean and median sort by decreasing values.}

\item{p.threshold}{Numeric. Threshold by which to highlight results. Defaults to .05}

\item{p.adjust}{character string for requested multiple comparisons
adjustment. Defaults to Benjamani-Hochberg}

\item{hide.non.sig}{Logical. If true, non significant (as defined by p.threshold) are not plotted.}

\item{non.parametric}{Logical. if true, test is performed using Wilcox test.
If false, Welch's t-test. Defaults to false.}
}
\value{
A ggplot object
}
\description{
This function performs the difference test and generates a ggplot object representing the results.
}
\examples{
data(GroupA)
GroupA_Net = as_NetSample(GroupA, 1:20, node.variables = list(community = c(rep(1, 10), rep(2,10))),
  sample.variables = list(group = c(rep(1, 10), rep(2,10))))
Jackknife_GroupA_Net = net_apply(GroupA_Net, node_jackknife)
GlobEff_GroupA_Net = net_stat_apply(Jackknife_GroupA_Net, global_efficiency)
diff_test_ggPlot(GlobEff_GroupA_Net)
}
