% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netgraph.discomb.R
\name{netgraph.discomb}
\alias{netgraph.discomb}
\title{Network graph for objects of class discomb}
\usage{
\method{netgraph}{discomb}(x, plastic = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{discomb}.}

\item{plastic}{A logical indicating whether the appearance of the
comparisons should be in '3D look'.}

\item{\dots}{Additional arguments passed on to
\code{\link{netgraph.netmeta}} (see Details).}
}
\description{
This function generates a graph of the evidence network.
}
\details{
The arguments \code{seq} and \code{iterate} are used internally and
cannot be specified by the user.
}
\examples{
# Artificial dataset
#
t1 <- c("A + B", "A + C", "A"    , "A"    , "D", "D", "E")
t2 <- c("C"    , "B"    , "B + C", "A + D", "E", "F", "F")
#
mean <- c(4.1, 2.05, 0, 0, 0.1, 0.1, 0.05)
se.mean <- rep(0.1, 7)
#
study <- paste("study", c(1:4, 5, 5, 5))
#
dat <- data.frame(mean, se.mean, t1, t2, study,
                  stringsAsFactors = FALSE)
#
trts <- c("A", "A + B", "A + C", "A + D",
  "B", "B + C", "C", "D", "E", "F")
#
comps <- LETTERS[1:6]

# Use netconnection() to display network information
#
netconnection(t1, t2, study)

dc1 <- discomb(mean, se.mean, t1, t2, study, seq = trts)

netgraph(dc1)

}
\seealso{
\code{\link{discomb}}, \code{\link{netgraph.netmeta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de},
  Gerta Rücker \email{gerta.ruecker@uniklinik-freiburg.de}
}
\keyword{hplot}
