% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankogram.default.R
\name{rankogram.default}
\alias{rankogram.default}
\title{Calculate rankogram from treatment effect samples}
\usage{
\method{rankogram}{default}(
  x,
  pooled = "unspecified",
  small.values = "desirable",
  cumulative.rankprob = FALSE,
  keep.samples = FALSE,
  nchar.trts = gs("nchar.trts"),
  ...
)
}
\arguments{
\item{x}{A matrix or data frame with treatment effects in columns and
samples in rows.}

\item{pooled}{A character string indicating whether samples come from
a common (\code{"common"}), random effects (\code{"random"}), or
\code{"unspecified"} model, can be abbreviated.}

\item{small.values}{An optional character string specifying whether small
treatment effects indicate a beneficial (\code{"desirable"}) or
harmful (\code{"undesirable"}) effect, can be abbreviated.}

\item{cumulative.rankprob}{A logical indicating whether cumulative
ranking probabilities should be printed.}

\item{keep.samples}{A logical indicating whether to keep the generated
samples.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
An object of class \code{rankogram} with corresponding \code{print}
and \code{plot} function. The object is a list containing the
following components:
\item{ranking.matrix.common}{Numeric matrix giving the probability
  of each treatment being at each possible rank for the common
  effects model.}
\item{ranking.common}{SUCRA values for the common effects model.}
\item{ranking.matrix.random}{Numeric matrix giving the probability
  of each treatment being at each possible rank for the random
  effects model.}
\item{ranking.random}{SUCRA values for the random effects model.}
\item{cumrank.matrix.common}{Numeric matrix giving the cumulative
  ranking probability of each treatment for the
  common effects model.}
\item{cumrank.matrix.random}{Numeric matrix giving the cumulative
  ranking probability of each treatment for the random effects
  model.}
\item{nsim, common, random}{As defined above},
\item{small.values, x}{As defined above},
}
\description{
This function calculates the probabilities of each treatment being
at each possible rank and the SUCRAs (Surface Under the Cumulative
RAnking curve) from a sample of treatment estimates in network
meta-analysis.
}
\details{
We derive a matrix showing the probability of each treatment being
at each possible rank. To this aim, we use samples and
summarise them using the ranking metric SUCRAs (Surface Under
the Cumulative RAnking curve).

The matrix / data frame in argument \code{x} must contain the sampled
effects for each treatment.
}
\examples{
p1 <- pairwise(treatment, event = r, n = N, studlab = author,
  data = dat.woods2010, sm = "OR")
net1 <- netmeta(p1, small.values = "desirable")

set.seed(1909) # get reproducible results
ran1 <- rankogram(net1, nsim = 100, common = FALSE,
  keep.samples = TRUE)
ran1

rankogram(ran1$samples.random, pooled = "random")

\dontrun{
p2 <- pairwise(treat = list(treatment1, treatment2, treatment3),
  event = list(resp1, resp2, resp3), n = list(n1, n2, n3),
  studlab = id, data = dat.linde2015, sm = "OR")
#
net2 <- netmeta(p2, common = FALSE, ref = "Placebo", small = "undesirable")

ran2 <- rankogram(net2, nsim = 100, common = FALSE,
  keep.samples = TRUE)
ran2

# Wrong ranking due to using the default,
# i.e., argument 'small.values = "desirable".
rankogram(ran2$samples.random, pooled = "random")
# Correct ranking 
rankogram(ran2$samples.random, pooled = "random",
  small.values = "undesirable")
}

}
\references{
Salanti G, Ades AE, Ioannidis JP (2011):
Graphical methods and numerical summaries for presenting results
from multiple-treatment meta-analysis: an overview and tutorial.
\emph{Journal of Clinical Epidemiology},
\bold{64}, 163--71
}
\seealso{
\code{\link{netmeta}}, \code{\link{netrank}},
  \code{\link{plot.rankogram}},
  \code{\link[metadat]{dat.woods2010}},
  \code{\link[metadat]{dat.linde2015}}
}
\author{
Theodoros Papakonstantinou \email{dev@tpapak.com}, Guido
  Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
