% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.netmeta.R
\name{as.data.frame.netmeta}
\alias{as.data.frame.netmeta}
\title{Create a data frame from an object of class netmeta}
\usage{
\method{as.data.frame}{netmeta}(x, row.names = NULL, optional = FALSE, details = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{netmeta}.}

\item{row.names}{\code{NULL} or a character vector giving the row
names for the data frame.}

\item{optional}{A logical. If \code{TRUE}, setting row names and
converting column names (to syntactic names) is optional.}

\item{details}{A logical. If \code{TRUE}, additional variables of
less interest are included in data frame.}

\item{\dots}{Additional arguments.}
}
\value{
A data frame is returned by the function
  \code{as.data.frame}.
}
\description{
The \code{as.data.frame} method returns a data frame containing
information on individual studies, e.g., estimated treatment effect
and its standard error.
}
\examples{
\donttest{
data(smokingcessation)

# Transform data from arm-based format to contrast-based format
#
pw1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")

# Conduct random effects network meta-analysis and show data frame
#
net1 <- netmeta(pw1, common = FALSE)
as.data.frame(net1)

data(Senn2013)

# Conduct network meta-analysis
#
net2 <- netmeta(TE, seTE, treat1, treat2, studlab,
  data = Senn2013, sm = "MD")

as.data.frame(net2)
as.data.frame(net2, details = TRUE)
}

}
\seealso{
\code{\link{netmeta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
