% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_generation.R
\name{generate_graph}
\alias{generate_graph}
\title{Generates a bigger graph by modifying an initial graph.}
\usage{
generate_graph(gr = NULL, del_edge = 0.1, new_nodes = 0.1, edge_increase = 0.1)
}
\arguments{
\item{gr}{The input graph to generate the next graph. If set to \code{NULL}
a graph using \code{igraph::sample_pa} is used as the input graph.}

\item{del_edge}{The proportion of edges deleted from the input graph. Default
set to \code{0.1}.}

\item{new_nodes}{The proportion of nodes added to the input graph. Default
set to \code{0.1}.}

\item{edge_increase}{The proportion of edges added to the input graph. Default
set to \code{0.1}.}
}
\value{
A graph.
}
\description{
Generates a bigger graph using parameters for node and edge growth.
}
\examples{
set.seed(1)
gr <- generate_graph()
gr

}
