% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAnet.R
\name{PCAnet}
\alias{PCAnet}
\title{PCAnet}
\usage{
PCAnet(qgraph_net, cormat, varTxt = F, repulse = F, repulsion = 1,
  principalArgs = list(), ...)
}
\arguments{
\item{qgraph_net}{an object of type \code{qgraph}}

\item{cormat}{the correlation matrix of the relevant data. If this argument is missing,
the function will assume that the adjacency matrix from \code{qgraph_net} is a correlation matrix}

\item{varTxt}{logical. Print the variance accounted for by the PCA in the lower left corner of the plot}

\item{repulse}{logical. Add a small repulsion force with wordcloud package to avoid node overlap?}

\item{repulsion}{scalar for the repulsion force (if repulse=T). Larger values add more repulsion}

\item{principalArgs}{additional arguments in list format passed to \code{psych::principal}}

\item{...}{additional arguments passed to \code{qgraph}}
}
\description{
Convenience function for converting a qgraph object to a layout determined
by principal components analysis
}
\details{
A network plotted with PCA can be interpreted based on coordinate placement
of each node. A node in the top right corner scored high on both the first and second
principal components
}
\references{
Jones, P. J., Mair, P., & McNally, R. J. (2017). Scaling networks for two-dimensional visualization: a tutorial. Retrieved from osf.io/eugsz
}
