\name{sim.fmri.data}
\alias{sim.fmri.data}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Simulate 3D or 4D fMRI data
}
\description{Simulates a 3D or 4D fMRI dataset for the specified design and with activation in the specified regions.
}
\usage{
sim.fmri.data(design = list(), image = list(), dim, nscan = NULL, TR = NULL, SNR, noise = c("none", "white", "temporal", "spatial", "low-frequency", "physiological", "task-related", "mixture"), temp = c("AR(1)", "state-space"), spat = c("corr", "gausRF", "gammaRF"), weights, verbose = TRUE, rhotemp = NULL, rhospat = NULL, lowfreq = NULL, heartfreq = NULL, respfreq = NULL, FWHM = NULL, gamma.shape = NULL, gamma.rate = NULL, anatomical = FALSE, template)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{design}{List generated by \code{\link{simprep.act.temp}} specifying the design. If not specified, noise images are generated.
}
  \item{image}{List generated by \code{\link{simprep.act.spat}} specifying the activated regions. If not specified, noise images are generated
}
  \item{dim}{Dimensions of the image space.
}
  \item{nscan}{Number of scans for noise images.
}
  \item{TR}{Repetition time for noise images.
}
  \item{SNR}{Signal-to-noise ratio.
}
  \item{noise}{Type of noise, default is white.
}
  \item{temp}{If noise=temporal or mixture, the temporal correlation structure.
}
  \item{spat}{If noise=spatial or mixture, the spatial correlation structure.
}
  \item{weights}{If noise=mixture, weights vector of six elements.
}
  \item{verbose}{Logical indicating if warning should be printed.
}
  \item{rhotemp}{If noise=temporal or noise=mixture, value of autocorrelation coefficient.
}
  \item{rhospat}{If noise=spatial or noise=mixture, and spat=corr, value of the correlation coefficient.
}
  \item{lowfreq}{If noise=low-frequency or noise=mixture, frequency of the low-frequency drift in seconds.
}
  \item{heartfreq}{If noise=physiological or noise=mixture, frequency of heart rate in Hz.
}
  \item{respfreq}{If noise=physiological or noise=mixture, frequency of respiratory rate in Hz.
}
  \item{FWHM}{If noise=spatial or noise=mixture, and spat=gausRF or gammaRF, value of the FWHM of the Gaussian kernel.
}
  \item{gamma.shape}{If noise=spatial or noise=mixture, and spat=gammaRF, value of the shape parameter of the gamma distribution.
}
  \item{gamma.rate}{If noise=spatial or noise=mixture, and spat=gammaRF, value of the rate parameter of the gamma distribution.
}
  \item{anatomical}{Logical indicating if an anatomical structure should be incorporated.
}
  \item{template}{If anatomical==TRUE, an array representing the anatomical structure with dimensions equal to dim.
}
}
\value{A 3D or 4D array specifying the values for each voxel in the data.
}
\author{M. Welvaert
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{sim.fmri.ts}}, \code{\link{simprep.act.temp}}, \code{\link{simprep.act.spat}}
}
\examples{
rm(list=ls())
design <- simprep.act.temp(T=200, ncond=1, onsets=seq(1,200,40), durations=20, TR=2, acc=0.1, hrf="double-gamma")
region <- simprep.act.spat(nregio=2, coord=matrix(c(32,15,57,45), ncol=2, byrow=TRUE), ext=c(10,7), form="sphere", fading=TRUE)
out <- sim.fmri.data(design=design, image=region, dim=c(64,64), SNR=1, noise="none")
#plot(out[32,15,], type="l")
## Not run:
# library(lattice)
# library(gplots)
# levelplot(out[,,10],scales=list(tck=0), col.regions=colorpanel(50,high="white",low="black"))
# End(Not run)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ high-level }
