% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap_filename.R
\name{remap_filename}
\alias{remap_filename}
\title{Build Filename (usually for images)}
\usage{
remap_filename(x, prefix = "", suffix = "")
}
\arguments{
\item{x}{input filename/character vector}

\item{prefix}{string to put in front of base of filename}

\item{suffix}{string to put at the end of base of filename}
}
\value{
Character vector
}
\description{
This is a simple function that helps with the case where you want to 
construct a filename (usually for an image) with the same base of the
filename, the same directory, but things added to the front or end
of that base filename, with the same extension.
}
\examples{
fname = file.path("/path/to/file", "original.nii.gz")
remap_filename(fname, prefix = "preproc_", "_with_gz")
fname = "original.nii"
remap_filename(fname, prefix = "note_", "_has_directory")
}
