% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writenii.R
\name{writeNIfTI2}
\alias{writeNIfTI2}
\alias{writenii}
\title{writeNIfTI with default non-reoirientation}
\usage{
writeNIfTI2(nim, filename, dtype = FALSE, compression = 9, ...)

writenii(nim, filename, dtype = TRUE, drop_dim = TRUE, warn = FALSE,
  compression = 9, ...)
}
\arguments{
\item{nim}{object of class \code{nifti}, passed to \code{\link{writeNIfTI}}}

\item{filename}{path to save the NIfTI file.  Suffix will be removed}

\item{dtype}{Should \code{\link{datatyper}} be run before writing?}

\item{compression}{compression level for gzipped files.}

\item{...}{Additional arguments pased to \code{\link{writeNIfTI}}}

\item{drop_dim}{Should \code{\link{drop_img_dim}} be run before writing?}

\item{warn}{Should warnings from \code{\link{writeNIfTI}} be 
printed?  If not, \code{\link{suppressWarnings}} is called}
}
\value{
Nothing
}
\description{
This function calls the \code{\link{writeNIfTI}} function from the 
\code{oro.nifti} package, but makes sure to remove \code{.nii} extension and
warnings can be suppressed.
}
\note{
While \code{writeNIfTI2} does not run \code{\link{datatyper}} as default, 
\code{writenii} does.  Additional functionality will be added to \code{writenii} likely
but will not to \code{writeNIfTI2}
}
