% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_vals.R
\docType{methods}
\name{mask_vals}
\alias{mask_vals}
\alias{mask_vals-methods,}
\alias{mask_vals<-}
\alias{mask_vals<-,nifti-method}
\alias{mask_vals<-,nifti,ANY,ANY-method}
\alias{mask_vals<-,anlz-method}
\alias{mask_vals<-,anlz,ANY,ANY-method}
\alias{mask_vals<-,array-method}
\alias{mask_vals<-,array,ANY,ANY-method}
\title{Extract or Replace Values Inside a Mask}
\usage{
mask_vals(object, mask)

mask_vals(object, mask) <- value

\S4method{mask_vals}{nifti}(object, mask) <- value

\S4method{mask_vals}{anlz}(object, mask) <- value

\S4method{mask_vals}{array}(object, mask) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{mask}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{.Data} field.}
}
\description{
Methods that act on the \code{.Data} field in a
NIfTI/ANALYZE imaget but only on values inside a mask.
}
\examples{
img = nifti(array(rnorm(10^3), dim = rep(10, 3)))
mask = img > 1.5
mask_vals(img, mask)
mask_vals(img, mask) = rep(4, sum(mask))
mask_vals(img, as(mask, "array")) = rep(4, sum(mask))
mask_vals(as(img, "array"), 
    as(mask, "array")) = rep(4, sum(mask))
}
