% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuro_install.R
\name{neuro_install}
\alias{neuro_install}
\alias{neuroc_install}
\alias{neurocLite}
\title{Neuroconductor Installer}
\usage{
neuro_install(
  repo,
  release = c("stable", "current"),
  release_repo = latest_neuroc_release(),
  upgrade_dependencies = FALSE,
  type = getOption("pkgType"),
  ...
)

neuroc_install(...)

neurocLite(...)
}
\arguments{
\item{repo}{Package name in neuroconductor}

\item{release}{Stable or current (development) versions/branches}

\item{release_repo}{Repository for release repository, passed to
\code{\link{install.packages}}.  If \code{release_repo = "github"},
then it will install using GitHub.  If you set this using
\code{\link{make_release_version}} or specify the URL directly,
it will override \code{release} option.}

\item{upgrade_dependencies}{Should dependencies be updated?
passed to \code{\link[devtools]{install}} if using
\code{release_repo = "github"}}

\item{type}{character, indicating the type of package to download and
install, passed to \code{\link{install.packages}}.}

\item{...}{additional arguments passed to
\code{\link{install.packages}}
or \code{\link[devtools]{install_github}} if
\code{release_repo = "github"}}
}
\value{
Result from  \code{\link{install.packages}} or
\code{\link[devtools]{install_github}}
}
\description{
Install function for neuroconductor packages
}
\examples{
\donttest{
   tlib = tempfile()
   dir.create(tlib, showWarnings = FALSE)
   system.time({
   install.packages("oro.asl",
   lib = tlib,
   repos = "https://neuroconductor.org/releases/2019/12/")
   })
   repos = getOption("repos")
   print(repos)
   #if (repos["CRAN"] == "@CRAN@") {
   #    repos["CRAN"] = "https://cloud.r-project.org"
   #    options(repos = repos)
   #}
   options(repos = NULL)
   print(getOption("repos"))
   neuro_install("oro.asl", lib = tlib,
   release_repo = "https://neuroconductor.org/releases/2019/12")
   options(repos = repos)
 }
\donttest{
   neuro_install("cifti", type = "source", lib = tlib)
   neuro_install("cifti",
   release_repo = latest_neuroc_release("stable"),
   lib = tlib)

   neuro_install("cifti", release_repo = "github")
}

}
