% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_list_files.R
\name{hcp_list_files}
\alias{hcp_list_files}
\alias{fcp_list_files}
\alias{openneuro_list_files}
\alias{hcp_list_dirs}
\alias{fcp_list_dirs}
\alias{openneuro_list_dirs}
\title{List files from HCP bucket}
\usage{
hcp_list_files(prefix = "", delimiter = NULL, query = NULL, ...)

fcp_list_files(prefix = "", delimiter = NULL, query = NULL, ...)

openneuro_list_files(prefix = "", delimiter = NULL, query = NULL, ...)

hcp_list_dirs(prefix = "HCP/", ...)

fcp_list_dirs(prefix = "data/Projects/", ...)

openneuro_list_dirs(prefix = NULL, ...)
}
\arguments{
\item{prefix}{directory folder to list files.  If \code{""}, then it will be
the root path}

\item{delimiter}{Delimiter to list files.  For example \code{".mat"},
for ".mat"}

\item{query}{Additional query arguments}

\item{...}{additional arguments passed to \code{\link{get_hcp_file}}}
}
\value{
List with the result of the GET command, the parsed result, and
the content from the result.
}
\description{
Lists a set of files from an HCP bucket for a specific sub-folder
}
\examples{
if (have_aws_key()){
x = hcp_list_files(prefix = "HCP/100307/unprocessed/3T/Diffusion",
   delimiter="bval")
t1_niis = hcp_list_files(prefix ="HCP/100307/T1w",
delimiter = ".nii.gz")
all_dirs = hcp_list_dirs("HCP/")
}

if (have_aws_key()){
 all_dirs = hcp_list_dirs("HCP/")
 cr =parse_list_files(all_dirs)$prefixes
}
\dontrun{
res = fcp_list_dirs()
projects = unlist(parse_list_files(res)$prefixes)
projects = unname(projects)
head(projects)
head(basename(projects))
}
res = openneuro_list_dirs()
projects = unlist(parse_list_files(res)$prefixes)
projects = unname(projects)
head(projects)
if (length(projects) > 0) {
head(basename(projects))
}
}
