% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_decode_player_ids.R
\name{decode_player_ids}
\alias{decode_player_ids}
\title{Decode the player IDs in nflfastR play-by-play data}
\usage{
decode_player_ids(pbp, ..., fast = TRUE)
}
\arguments{
\item{pbp}{is a Data frame of play-by-play data scraped using \code{\link[=fast_scraper]{fast_scraper()}}.}

\item{...}{Additional arguments passed to a message function (for internal use).}

\item{fast}{If \code{TRUE} the IDs will be decoded with the high efficient
function \link[gsisdecoder:decode_ids]{decode_ids}. If \code{FALSE} an nflfastR internal
function will be used for decoding (it is generally not recommended to do this,
unless there is a problem with \link[gsisdecoder:decode_ids]{decode_ids}
which can take several days to fix on CRAN.)}
}
\value{
The input data frame of the parameter \code{pbp} with decoded player IDs.
}
\description{
Takes all columns ending with \code{'player_id'} as well as the
variables \code{'passer_id'}, \code{'rusher_id'}, \code{'fantasy_id'},
\code{'receiver_id'}, and \code{'id'} of an nflfastR play-by-play data set
and decodes the player IDs to the commonly known GSIS ID format 00-00xxxxx.

The function uses by default the high efficient \link[gsisdecoder:decode_ids]{decode_ids}
of the package \href{https://cran.r-project.org/package=gsisdecoder}{\code{gsisdecoder}}.
In the unlikely event that there is a problem with this function, an nflfastR
internal decoder can be used with the option \code{fast = FALSE}.
}
\examples{
\donttest{
# Decode data frame consisting of some names and ids
decode_player_ids(data.frame(
  name = c("P.Mahomes", "B.Baldwin", "P.Mahomes", "S.Carl", "J.Jones"),
  id = c(
    "32013030-2d30-3033-3338-3733fa30c4fa",
    NA_character_,
    "00-0033873",
    NA_character_,
    "32013030-2d30-3032-3739-3434d4d3846d"
  )
))
}
}
