% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanes}
\alias{nhanes}
\title{Download an NHANES table and return as a data frame.}
\usage{
nhanes(nh_table, includelabels = FALSE)
}
\arguments{
\item{nh_table}{The name of the specific table to retrieve.}

\item{includelabels}{If TRUE, then include SAS labels as variable attribute (default = FALSE).}
}
\value{
The table is returned as a data frame.
}
\description{
Use to download NHANES data tables that are in SAS format.
}
\details{
Downloads a table from the NHANES website as is, i.e. in its entirety
with no modification or cleansing. NHANES tables 
are stored in SAS '.XPT' format but are imported as a data frame.
Function nhanes cannot be used to import limited 
access data.
}
\examples{
\donttest{nhanes('BPX_E')}
\donttest{nhanes('FOLATE_F', includelabels = TRUE)}
}
