% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebuild_topology.R
\name{make_node_topology}
\alias{make_node_topology}
\title{get node topology from edge topology (DEPRECATED)}
\usage{
make_node_topology(x, add_div = NULL, add = TRUE)
}
\arguments{
\item{x}{data.frame with an identifier and to identifier in the
first and second columns.}

\item{add_div}{data.frame containing id and toid diverted paths to add.
Should have id and toid fields in the first and second columns. Names
are not used.}

\item{add}{logical if TRUE, a tocomid column will be added, otherwise
a data.frame with two columns will be returned.}
}
\value{
data.frame containing id, fromnode, and tonode attributes or all
attributes provided with id, fromnode and tonode in the first three columns.
}
\description{
creates a node topology table from an edge topology
}
\examples{
source(system.file("extdata/new_hope_data.R", package = "nhdplusTools"))

x <- dplyr::select(get_tocomid(
  dplyr::select(new_hope_flowline, COMID, FromNode, ToNode, Divergence, FTYPE,
                AreaSqKM, LENGTHKM, GNIS_ID)
), -tonode, -fromnode)

head(y <- make_node_topology(x))

# just the divergences which have unique fromids in x but don't in new hope.
div <- get_tocomid(dplyr::select(new_hope_flowline, COMID, FromNode, ToNode),
                   return_dendritic = FALSE,
                   remove_coastal = FALSE)
div <- div[div$tocomid \%in\%
             new_hope_flowline$COMID[new_hope_flowline$Divergence == 2],]

y <- make_node_topology(x, div)

}
