% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_tournaments.R
\name{nhl_tournaments}
\alias{nhl_tournaments}
\alias{nhl_tournaments_playoffs}
\alias{nhl_tournaments_olympics}
\alias{nhl_tournaments_worldcups}
\title{Retrieve data on tournaments from the API}
\usage{
nhl_tournaments(tournamentTypes, seasons = NULL, expand = NULL)

nhl_tournaments_playoffs(seasons = NULL, expand = NULL)

nhl_tournaments_olympics(seasons = NULL, expand = NULL)

nhl_tournaments_worldcups(seasons = NULL, expand = NULL)
}
\arguments{
\item{tournamentTypes}{\code{character()}, vector of one or more
tournament types. Currently supported types seem to be
\itemize{
\item \code{"playoffs"}
\item \code{"olympics"}
\item \code{"worldCup"}
}

Those are exposed via shorthand functions
\itemize{
\item \code{\link[=nhl_tournaments_playoffs]{nhl_tournaments_playoffs()}}
\item \code{\link[=nhl_tournaments_olympics]{nhl_tournaments_olympics()}}
\item \code{\link[=nhl_tournaments_worldcups]{nhl_tournaments_worldcups()}}
}}

\item{seasons}{\code{numeric()}, \code{integer()} or \code{character()},
vector of starting years of desired seasons in \code{YYYY}
format, e.g. \code{1995} or \code{"1995"} for season 1995-1996.
Accepts vectors such as \code{c(1995:2000, 2010)} to generate
multiple seasons.

Alternatively, also accepts \code{character()} with seasons in the
format \code{"YYYYZZZZ"}, where \code{ZZZZ = YYYY + 1}, e.g. \code{"19951996"}.
This is the format that ultimately gets sent to the NHL API.

Some API endpoints, notably \code{seasons} exposed via \code{\link[=nhl_seasons]{nhl_seasons()}}
also allow the value \code{"current"} to passed. This value will be
returned unchanged.}

\item{expand}{\code{character()}, of parameters passed as \code{expand}
to the API URL. Two valid examples seem to be \code{"round.series"}
and \code{"schedule.game.seriesSummary"}. \code{NULL} for no expand
parameter.}
}
\value{
\code{list}, with information on tournaments, one element per
\code{tournamentTypes} and parameters (\code{seasons} and \code{expand})
combinations.
}
\description{
Retrieve data on tournaments from the API
}
\section{Functions}{
\itemize{
\item \code{nhl_tournaments_playoffs}: Shortcut to get information on playoffs.

\item \code{nhl_tournaments_olympics}: Shortcut to get information on Olympics.

\item \code{nhl_tournaments_worldcups}: Shortcut to get information on world cups.
}}

\examples{
\dontrun{
  # Get info on playoffs in one season
  nhl_tournaments("playoffs", 2015)

  # Get info on playoffs in 2 seasons, expand rounds
  nhl_tournaments("playoffs", 2015:2016, "round.series")
}

\dontrun{
  nhl_tournaments_playoffs(2015:2016, "round.series")
}
\dontrun{
  nhl_tournaments_olympics(2009, "round.series")
}
\dontrun{
  nhl_tournaments_worldcups(2003)
}
}
