% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsi_oli.R
\name{dsi_oli}
\alias{dsi_oli}
\title{Landsat Surface Reflectance Derived Spectral Indices}
\usage{
dsi_oli(x)
}
\arguments{
\item{x}{A raster layer object with the Top of atmosphere planetary reflectance with at least the first seven bands.}
}
\value{
Layer 1 - Normalized Difference Vegetation Index

Layer 2 - Enhanced Vegetation Index

Layer 3 - Soil Adjusted Vegetation Index

Layer 4 - Modified Soil Adjusted Vegetation Index

Layer 5 - Normalized Difference Moisture Index

Layer 6 - Normalized Burn Ratio

Layer 7 - Normalized Burn Ratio 2

Layer 8 - Advanced Vegetation Index

Layer 9 - Bare Soil Index
}
\description{
This function requires Landsat Surface Reflectance from Landsat 8 Operational Land Imager to derive spectral indices.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
dsi_oli(x)

}
\references{
\url{https://www.usgs.gov/core-science-systems/nli/landsat/landsat-surface-reflectance-derived-spectral-indices}.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
