% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsams.R
\name{nsams}
\alias{nsams}
\alias{nsams.default}
\title{Number of MCMC Samples}
\usage{
nsams(x, ...)

\method{nsams}{default}(x, ...)
}
\arguments{
\item{x}{The R object.}

\item{...}{Unused.}
}
\value{
A count of the total number of sample values.
}
\description{
Gets the number of MCMC samples (simulations * terms)
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Number of sample values of default object
}}

\examples{
nsams(nlist(x = 2))
nsams(nlist(x = 1:2))
nsams(nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7))))
}
\seealso{
\code{\link[=nsims]{nsims()}} and \code{\link[=nterms]{nterms()}}
}
