% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCOVbin.R
\name{makeCOVbin}
\alias{makeCOVbin}
\title{Discretise numeric data into categorical variable}
\usage{
makeCOVbin(X,
           K,
           cutoffs,
           adjust0bin = TRUE, ...)
}
\arguments{
\item{X}{A numeric vector corresponding to Y.}

\item{K}{Number of bins.}

\item{cutoffs}{A numeric vector of two or more unique cut points.}

\item{adjust0bin}{Adjust bin with 0 observation if TRUE.}

\item{...}{Arguments to be passed to methods.}
}
\value{
The result of binning and the summary of the binning results
}
\description{
Discretise numeric value into a categorical variable using  
 the user-defined breaks. If cutoffs and the number of bins (K) are NULL, 
  find the best number of bins using optK function and find the best 
  cutoff values using FindBestCut function.
}
\examples{
data(origdata)
CUT = FindBestCut(origdata$TIME,8)$cutoffs
makeCOVbin(origdata$TIME,K=8,cutoffs=CUT)
}
\references{
Lavielle, M. and Bleakley, K.
            (2011). Automatic data binning for improved visual 
                    diagnosis of pharmacometric models. 
                    Journal of pharmacokinetics and pharmacodynamics, 38(6), 861-871.
}
