## RcppExports.R: population PK/PD modeling library
##
## Copyright (C) 2014 - 2016  Wenping Wang
##
## This file is part of nlmixr.
##
## nlmixr is free software: you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 2 of the License, or
## (at your option) any later version.
##
## nlmixr is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with nlmixr.  If not, see <http:##www.gnu.org/licenses/>.

# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' concentrations from a linear compartment model
#'
#' concentrations from a linear compartment model by close-form solutions
#'
#' @param obs_time times at which an observation is desired
#' @param dose_time times at which doses are given
#' @param dose a vector of doses
#' @param Tinf a vector of infusion duration
#' @param params model-appropriate parameters per parameterization
#' @param ncmt number of compartments
#' @param oral logical, whether oral absorption is true
#' @param infusion logical, whether infusion is true
#' @param parameterization type of parameterization, 1=clearance/volume, 2=micro-constants
#' @return calculated concentrations
#' @export lin_cmt
lin_cmt <- function(obs_time,dose_time,dose,Tinf,params,oral,infusion,ncmt,parameterization) {
    .Call(nlmixr_lin_cmt, PACKAGE = 'nlmixr', obs_time,dose_time,dose,Tinf,params,oral,infusion,ncmt,parameterization)
}

#require(nlmixr)
#lin_cmt(0:72*1.0, 0:2*24*1.0, rep(10.0,3), 0, c(.1, 1, .2, 0), 1, 0, 1, 2)
