% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppManualExports.R
\name{lin_cmt}
\alias{lin_cmt}
\title{concentrations from a linear compartment model}
\usage{
lin_cmt(
  obs_time,
  dose_time,
  dose,
  Tinf,
  params,
  oral,
  infusion,
  ncmt,
  parameterization
)
}
\arguments{
\item{obs_time}{times at which an observation is desired}

\item{dose_time}{times at which doses are given}

\item{dose}{a vector of doses}

\item{Tinf}{a vector of infusion duration}

\item{params}{model-appropriate parameters per parameterization}

\item{oral}{logical, whether oral absorption is true}

\item{infusion}{logical, whether infusion is true}

\item{ncmt}{number of compartments}

\item{parameterization}{type of parameterization, 1=clearance/volume, 2=micro-constants}
}
\value{
calculated concentrations
}
\description{
concentrations from a linear compartment model by close-form solutions
}
\details{
This is used by some of the internal nlmixr routines, for example
the low level nlme estimation with nlmixr. With the nlmixr functions
you should use `linCmt()` instead.  It is documented at
\url{https://nlmixrdevelopment.github.io/RxODE/articles/RxODE-model-types.html#solved-compartment-models}
}
