% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UNI.addpara_helper.R
\name{getUNI.addpara}
\alias{getUNI.addpara}
\title{Get Additional Parameters Related to Interval-specific Slopes, Interval-specific Changes and Values of
Change-from-baseline for Latent Change Score Models for Longitudinal Outcome}
\usage{
getUNI.addpara(
  dat,
  curveFun,
  intrinsic = NULL,
  t_var,
  records,
  growth_TIC,
  decompose,
  starts
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables
with repeated measurements and occasions, and time-invariant covariates (TICs) if any. It takes the value passed from
\code{getLCSM()} or \code{getTVCmodel()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for latent change score
models include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"} (or \code{"EXP"}), \code{"Jenss-Bayley"}
(or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the value passed from \code{getLCSM()} or
\code{getTVCmodel()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the
value passed from \code{getLCSM()} or \code{getTVCmodel()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable at each study wave.
It takes the value passed from \code{getLCSM()} or \code{getTVCmodel()}.}

\item{records}{A numeric vector specifying indices of the study waves. It takes the value passed from \code{getLCSM()}
or \code{getTVCmodel()}.}

\item{growth_TIC}{A string or character vector specifying the column name(s) of time-invariant covariate(s) contributing
to the variability of growth factors if any. It takes the value passed from \code{getLCSM()} or \code{getTVCmodel()}.}

\item{decompose}{An integer specifying the decomposition option for temporal states. Supported values include \code{0} (no
decomposition), \code{1} (decomposition with interval-specific slopes as temporal states), \code{2} (decomposition with
interval-specific changes as temporal states), and \code{3} (decomposition with change-from-baseline as temporal states).
It takes the value passed from \code{getTVCmodel()}. The argument is set as \code{NULL} when fitting a latent change score
model.}

\item{starts}{A list containing initial values for the parameters, either takes the value passed from \code{getLCSM()} or
\code{getTVCmodel()}, or derived by the helper function \code{getUNI.initial()} or \code{getTVC.initial()}.}
}
\value{
A list containing the specification of the means and variances of interval-specific slopes, interval-specific
changes, and values of change-from-baseline for latent change score models.
}
\description{
This function derives additional parameters for latent change score models. In particular, it
specifies the means and variances of interval-specific slopes, interval-specific changes, and values of change-
from-baseline.
}
\keyword{internal}
