% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_lm.R
\name{simulate_lm}
\alias{simulate_lm}
\title{Simulate responses from a linear model \code{\link[stats]{lm}}}
\usage{
simulate_lm(
  object,
  psim = 1,
  nsim = 1,
  resid.type = c("resample", "normal", "wild"),
  value = c("matrix", "data.frame"),
  ...
)
}
\arguments{
\item{object}{object of class \code{\link[stats]{lm}}}

\item{psim}{parameter simulation level (an integer, 0, 1, 3, 4).}

\item{nsim}{number of simulations to perform}

\item{resid.type}{type of residual to include (resample, normal or wild)}

\item{value}{either \sQuote{matrix} or \sQuote{data.frame}}

\item{...}{additional arguments (none used at the moment)}
}
\value{
matrix or data.frame with responses
}
\description{
The function \code{\link[stats]{simulate}} does not consider the 
uncertainty in the estimation of the model parameters. This function will attempt 
to do this.
}
\details{
Simulate responses from a linear model \code{\link[stats]{lm}}


These are the options that control the parameter simulation level
\describe{
  \item{psim = 0}{returns the fitted values}
  \item{psim = 1}{simulates a beta vector (mean response)}
  \item{psim = 2}{simulates a beta vector and adds resampled residuals (similar to observed data)}
  \item{psim = 3}{simulates a beta vector, considers uncertainty in the variance covariance matrix of beta and adds residuals (prediction)}
  \item{psim = 4}{only adds residuals according to resid.type (similar to simulate.lm)}
 }
The residual type (resid.type) controls how the residuals are generated. 
They are either resampled, simulated from a normal distribution or \sQuote{wild} where the
Rademacher distribution is used (\url{https://en.wikipedia.org/wiki/Rademacher_distribution}).
Resampled and normal both assume iid, but \sQuote{normal} makes the stronger assumption of normality.
\sQuote{wild} does not assume constant variance, but it assumes symmetry.
}
\examples{
\donttest{
require(ggplot2)
data(Orange)
fit <- lm(circumference ~ age, data = Orange)
sims <- simulate_lm(fit, nsim = 100, value = "data.frame")

ggplot(data = sims) + 
  geom_line(aes(x = age, y = sim.y, group = ii), 
            color = "gray", alpha = 0.5) + 
  geom_point(aes(x = age, y = circumference)) 
}


}
\references{
See
\dQuote{Inference Based on the Wild Bootstrap} James G. MacKinnon
\url{https://www.math.kth.se/matstat/gru/sf2930/papers/wild.bootstrap.pdf}
\dQuote{Bootstrap in Nonstationary Autoregression} Zuzana Praskova 
\url{https://dml.cz/bitstream/handle/10338.dmlcz/135473/Kybernetika_38-2002-4_1.pdf}
\dQuote{Jackknife, Bootstrap and other Resampling Methods in Regression Analysis} C. F. J. Wu.
The Annals of Statistics. 1986. Vol 14. 1261-1295.
}
