% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_lme.R
\name{boot_lme}
\alias{boot_lme}
\alias{boot_gls}
\title{Bootstraping for linear mixed models}
\usage{
boot_lme(object, f = NULL, R = 999, psim = 1, cores = 1L, data = NULL, ...)

boot_gls(object, f = NULL, R = 999, psim = 1, cores = 1L, data = NULL, ...)
}
\arguments{
\item{object}{object of class \code{\link[nlme]{lme}} or \code{\link[nlme]{gls}}}

\item{f}{function to be applied (and bootstrapped), default coef (gls) or fixef (lme)}

\item{R}{number of bootstrap samples, default 999}

\item{psim}{simulation level for vector of fixed parameters either for \code{\link{simulate_gls}} or \code{\link{simulate_lme}}}

\item{cores}{number of cores to use for parallel computation}

\item{data}{optional data argument (useful/needed when data are not in an available environment).}

\item{...}{additional arguments to be passed to function \code{\link[boot]{boot}}}
}
\description{
Bootstraping tools for linear mixed-models using a consistent interface

bootstrap function for objects of class \code{\link[nlme]{gls}}
}
\details{
This function is inspired by \code{\link[car]{Boot}}, which does not
seem to work with \sQuote{gls} or \sQuote{lme} objects. This function makes multiple copies 
of the original data, so it can be very hungry in terms of memory use, but
I do not believe this to be a big problem given the models we typically fit.
}
\examples{
\donttest{
require(nlme)
require(car)
data(Orange)

fm1 <- lme(circumference ~ age, random = ~ 1 | Tree, data = Orange)
fm1.bt <- boot_lme(fm1, R = 50)

hist(fm1.bt)

}

}
