% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IA_tab.R
\name{IA_tab}
\alias{IA_tab}
\alias{print.IA_tab}
\alias{plot.IA_tab}
\title{Indexes of Agreement Table}
\usage{
IA_tab(obs, sim, object, null.object)

\method{print}{IA_tab}(x, ..., digits = 2)

\method{plot}{IA_tab}(x, y, ..., type = c("OvsS", "RvsS"))
}
\arguments{
\item{obs}{vector with observed data}

\item{sim}{vector with simulated data (should be the same length as observed)}

\item{object}{alternative to the previous two arguments. An object of class \sQuote{lm}, \sQuote{nls}, \sQuote{lme} or \sQuote{nlme}}

\item{null.object}{optional object which represents the \sQuote{null} model. It is an intercept-only model
by default. (Not used at the moment).}

\item{x}{object of class \sQuote{IA_tab}.}

\item{...}{additional plotting arguments (none use at the moment).}

\item{digits}{number of digits for rounding (default is 2)}

\item{y}{not used at the moment}

\item{type}{either \dQuote{OvsS} (observed vs. simulated) or \dQuote{RvsS} (residuals vs. simulated).}
}
\description{
Indexes of agreement

printing function for IA_tab

plotting function for a IA_tab, it requires \sQuote{ggplot2}
}
\details{
This function returns several indexes that might be useful for interpretation

For objects of class \sQuote{lm} and \sQuote{nls} \cr
bias: mean(obs - sim) \cr
intercept: intercept of the model obs ~ beta_0 + beta_1 * sim + error \cr
slope: slope of the model obs ~ beta_0 + beta_1 * sim + error \cr
RSS (deviance): residual sum of squares of the previous model \cr
MSE (RSS / n): mean squared error; where n is the number of observations \cr
RMSE: squared root of the previous index \cr
R2.1: R-squared extracted from an \sQuote{lm} object \cr
R2.2: R-squared computed as the correlation between observed and simulated to the power of 2. \cr
ME: model efficiency \cr
NME: Normalized model efficiency \cr
Corr: correlation between observed and simulated \cr
ConCorr: concordance correlation  \cr

For objects of class \sQuote{gls}, \sQuote{gnls}, \sQuote{lme} or \sQuote{nlme} there
are additional metrics such as:


 \url{https://en.wikipedia.org/wiki/Coefficient_of_determination} \cr
 \url{https://en.wikipedia.org/wiki/Nash-Sutcliffe_model_efficiency_coefficient} \cr
 \url{https://en.wikipedia.org/wiki/Concordance_correlation_coefficient}
}
\examples{
\donttest{
require(nlme)
require(ggplot2)
## Fit a simple model and then compute IAs
data(swpg)
#' ## Linear model
fit0 <- lm(lfgr ~ ftsw + I(ftsw^2), data = swpg)
ias0 <- IA_tab(object = fit0)
ias0
## Nonlinear model
fit1 <- nls(lfgr ~ SSblin(ftsw, a, b, xs, c), data = swpg)
ias1 <- IA_tab(object = fit1)
ias1
plot(ias1)
## Linear Mixed Models
data(barley, package = "nlraa")
fit2 <- lme(yield ~ NF + I(NF^2), random = ~ 1 | year, data = barley)
ias2 <- IA_tab(object = fit2)
ias2
## Nonlinear Mixed Model
barleyG <- groupedData(yield ~ NF | year, data = barley)
fit3L <- nlsLMList(yield ~ SSquadp3(NF, a, b, c), data = barleyG)
fit3 <- nlme(fit3L, random = pdDiag(a + b ~ 1))
ias3 <- IA_tab(object = fit3)
ias3
plot(ias3)
## Plotting model
prds <- predict_nlme(fit3, interval = "conf", plevel = 0)
barleyGA <- cbind(barleyG, prds)
ggplot(data = barleyGA, aes(x = NF, y = yield)) + 
   geom_point() + 
   geom_line(aes(y = Estimate)) + 
   geom_ribbon(aes(ymin = Q2.5, ymax = Q97.5), 
               fill = "purple", alpha = 0.2)
## R2M for model 2
R2M(fit2)
## R2M for model 3
R2M(fit3)

}

}
\seealso{
\code{\link{IC_tab}}
}
