% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glance.R
\name{glance}
\alias{glance}
\title{Take a glance at a model}
\usage{
glance(x)
}
\arguments{
\item{x}{An object of class \code{timedist}.}
}
\value{
\code{glance()} returns a one row \code{data.frame} with the columns
\item{sigma}{the square root of the estimated residual variance}
\item{isConv}{whether the fit successfully converged}
\item{finTol}{the achieved convergence tolerance}
\item{logLik}{the data's log-likelihood under the model}
\item{AIC}{the Akaike Information Criterion}
\item{BIC}{the Bayesian Information Criterion}
\item{deviance}{deviance}
\item{df.residual}{residual degrees of freedom}
\item{RSS}{corrected residual sum of squares}
\item{nobs}{the number of observations from the model fit}
}
\description{
Construct a single row of model summary statistics.
}
\examples{
tdTilia <- tdData(tilia, x = "Day", y = "Trees")
model <- timedist(data = tdTilia, x = "Day", y = "propMax", r = 0.1, c = 0.5, t = 120)
glance(model)

}
