% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_profile.R
\name{display_profile}
\alias{display_profile}
\title{Display 3D profiles}
\usage{
display_profile(
  profile,
  numclient = FALSE,
  color = "Blues",
  language = "en",
  theme = "dark"
)
}
\arguments{
\item{profile}{a vector or a matrix row containing the profile to display. The day/hour data are contained in the column names.}

\item{numclient}{logical. Whether the first value of the row is an identifier.}

\item{color}{color of the display. Possibilities are the ones provided by \url{http://colorbrewer2.org}.}

\item{language}{in which language the day/hour names are written. For now, the possibilities are "en" for english and "fr" for french.}

\item{theme}{A theme to use. The only valid values are "" and "dark".}
}
\value{
Creates a 3D-heatmap displayed in the Viewer tab.
}
\description{
This function display profiles of 3 dimensions (day, hour, number of observations). It has been created to display
profiles from the \code{nmfem} package data.
}
\examples{
display_profile(travelers[sample(nrow(travelers),1), ], numclient = TRUE)
}
