% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000generate.R
\docType{data}
\name{MAEDtravel}
\alias{MAEDtravel}
\title{Trip dataset}
\format{
A dataframe containing:
\describe{
  \item{PeID}{individual index}
  \item{PeGenF}{gender of the individual}
  \item{PeAge}{age in years}
  \item{PeEduc}{education level}
  \item{PeEmploy}{employment state}
  \item{HhCh}{type of household: with children or without children}
  \item{WeID}{trip index}
  \item{choice}{chosen mode: 1 - walk, 2 - bike, 3 - car, 4 -public transport (PT)}
  \item{dist}{trip distance, km}
  \item{avl_1}{availability dummy for mode 1, walk}
  \item{avl_2}{availability dummy for mode 2, bike}
  \item{avl_3}{availability dummy for mode 3, car}
  \item{avl_4}{availability dummy for mode 4, PT}
  \item{chc_1}{choice dummy for mode 1, walk}
  \item{chc_2}{choice dummy for mode 2, bike}
  \item{chc_3}{choice dummy for mode 3, car}
  \item{chc_4}{choice dummy for mode 4, PT}
  \item{cost_3}{cost of car mode}
  \item{cost_4}{cost of PT mode}
  \item{dur_1}{trip duration with mode 1, minutes}
  \item{dur_2}{trip duration with mode 2, minutes}
  \item{dur_3}{trip duration with mode 3, minutes}
  \item{vdur_4}{in vehicle time mode 4, minutes}
  \item{acc_4}{time to stop or from stop for mode 4, minutes}
  \item{HhCarPark}{dummy, car parking at home available}
  \item{JobCarPark}{dummy,car parking at workplace available}
  \item{PbAvl_3}{dummy, ar parking restrictions (time and/or cost) in-force at the destination of the trip}
  \item{servIdx_4}{public transport service interval in minutes}
  \item{stopUs1R1_4}{necessary number of changes to reach the destination with public transport}
  \item{leis}{trip purpose leisure, effect coding}
  \item{work}{trip purpose work, effect coding}
  \item{oth}{trip purpose other, effect coding}
  \item{int_1}{inertia for mode 1}
  \item{int_2}{inertia for mode 2}
  \item{int_3}{inertia for mode 3}
  \item{int_4}{inertia for mode 4}}
}
\usage{
data(MAEDtravel)
}
\description{
Data gathered in Austria in 2015 according to Mobility-Activity-Expenditure-Dairy (MAED), which reported all trips, activities (time use) and expenditures of 737 persons over a whole week.
}
\details{
For more on data collection and description see \insertCite{aschauer2015}{nmm} and \insertCite{aschauer2018}{nmm}.

A variant of this dataset was used in:  \insertCite{schmid2017}{nmm}, \insertCite{jokubauskaite2018}{nmm} and \insertCite{hoessinger2018}{nmm}.

To get the full dataset please contact r.hoessinger@boku.ac.at.

Transport modes available: walk, bike, car, public transport (PT).
The inertia variable (int_i) is a dummy, which is equal to one if the mode 
chosen by a person for a trip at the start of the current tour is the same as
the one chosen in the previous tour made for the same purpose, and zero 
otherwise.
Variables for trip purpose (leis, work, oth) were created using the effect 
coding.
}
\examples{
data(MAEDtravel)
}
\references{
\insertRef{aschauer2018}{nmm}

\insertRef{aschauer2015}{nmm}

\insertRef{hoessinger2018}{nmm}

\insertRef{jokubauskaite2018}{nmm}

\insertRef{schmid2017}{nmm}
}
\keyword{datasets}
