% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_trim.R
\name{raster_trim}
\alias{raster_trim}
\title{Wrapper for \code{raster::trim} on \code{stars} objects}
\usage{
raster_trim(x)
}
\arguments{
\item{x}{A \code{stars} object}
}
\value{
A \code{stars} object with the trimmed result
}
\description{
This is a wrapper around \code{raster::trim}, to apply the function on \code{stars} objects without needing to convert to and from a \code{Raster*} object.
}
\examples{
library(stars)
tif = system.file("tif/L7_ETMs.tif", package = "stars")
r = read_stars(tif)
r[[1]][1:50, , 1:6] = NA
r[[1]][, 1:100, 1:6] = NA
plot(r)
r = raster_trim(r)
plot(r)

}
