% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{Qsym.ct}
\alias{Qsym.ct}
\title{\eqn{Q}-symmetry Contingency Table (QCT)}
\usage{
Qsym.ct(x, lab, is.ipd = TRUE, ...)
}
\arguments{
\item{x}{The IPD matrix (if \code{is.ipd=TRUE}) or a data set of points in matrix or data frame form where points
correspond to the rows (if \code{is.ipd = FALSEALSE}).}

\item{lab}{The \code{vector} of class labels (numerical or categorical)}

\item{is.ipd}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, \code{x} is taken as the inter-point distance
matrix, otherwise, \code{x} is taken as the data set with rows representing the data points.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
Returns the \eqn{k \times 3} QCT where \eqn{k} is the number of classes in the data set.
}
\description{
Returns the \eqn{k \times 3} contingency table for \eqn{Q}-symmetry (i.e. \eqn{Q}-symmetry contingency table (QCT)) given the 
IPD matrix or data set \code{x} where \eqn{k} is the number of classes in the data set.
Each row in the QCT is the vector of number of points with shared NNs,
\eqn{Q_i=(Q_{i0},Q_{i1},Q_{i2})} where \eqn{Q_{ij}} is the number of class \eqn{i} points that are NN to class \eqn{j} points
for \eqn{j=0,1} and \eqn{Q_{i2}} is the number of class \eqn{i} points that are NN to class \eqn{j} or more points.
That is, this function pools the cells 3 or larger together for \eqn{k} classes, so \eqn{Q_2}, \eqn{Q_3} etc. are pooled,
so the column labels are \eqn{Q_0}, \eqn{Q_1} and \eqn{Q_2} with the last one is actually sum of \eqn{Q_j} for \eqn{j \ge 2}.
Rows the QCT are labeled with the corresponding class labels.

\eqn{Q}-symmetry is also equivalent to Pielou's second type of NN symmetry
or the symmetry in the shared NN structure for all classes.

The argument \code{is.ipd} is a logical argument (default=\code{TRUE}) to determine the structure of the argument \code{x}.
If \code{TRUE}, \code{x} is taken to be the inter-point distance (IPD) matrix, and if \code{FALSE}, \code{x} is taken to be the data set
with rows representing the data points.

See also
(\insertCite{pielou:1961,ceyhan:SWJ-spat-sym2014;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(n*3),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)

Qsym.ct(ipd,cls)
Qsym.ct(Y,cls,is.ipd = FALSE)
Qsym.ct(Y,cls,is.ipd = FALSE,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
Qsym.ct(ipd,fcls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)

Qsym.ct(ipd,cls)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{sharedNNmc}}, \code{\link{Qsym.test}} and \code{\link{scct}}
}
\author{
Elvan Ceyhan
}
