% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rdiag.clust}
\alias{rdiag.clust}
\title{Generation of Points with Clusters along the First Diagonal}
\usage{
rdiag.clust(n, k, d, sd = 1/6, distribution = c("uniform", "bvnormal"))
}
\arguments{
\item{n}{A positive integer representing the number of points to be generated from the two clusters}

\item{k}{A positive integer representing the number of clusters to be generated}

\item{d}{Shift in the first diagonal indicating the level of clustering in the data. Larger absolute values in
either direction (i.e. positive or negative) would yield stronger clustering.}

\item{sd}{The standard deviation of the components of the bivariate normal distribution with default \eqn{sd=1/6}, 
used only when \code{distribution="bvnormal"}.}

\item{distribution}{The argument determining the distribution of each cluster. Takes on values \code{"uniform"} and
\code{"bvnormal"} whose centers are \eqn{d} units apart along the first diagonal direction.}
}
\value{
A \code{list} with the elements
\item{type}{The type of the clustering pattern}
\item{parameters}{The number of clusters, \code{k}, the diagonal shift d representing the level of clustering
(for both distribution types) and standard deviation, \code{sd}, for the bivariate normal distribution only}
\item{gen.points}{The output set of generated points from the clusters.}
\item{desc.pat}{Description of the clustering pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The number of generated points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated points}
}
\description{
An object of class \code{"Clusters"}.

Generates \code{n} 2D points with \code{k} (\eqn{k \ge 2}) clusters along the first diagonal 
where about \eqn{n/k} points belongs to each cluster.

If \code{distribution="uniform"}, the points are uniformly generated in their square
supports where one square is the unit square (i.e., with vertices \eqn{(0,0), (1,0), (1,1),(0,1)}), and 
the others are unit squares translated \eqn{j \sqrt{2} d}  units along the first diagonal for \eqn{j=1,2,\ldots,k-1}
(i.e. with vertices \eqn{(j d,j d), (1+j d,j d), (1+j d,1+j d),(j d,1+j d)}). 

If \code{distribution="bvnormal"}, the points are generated from the bivariate normal distribution with means equal to the
centers of the above squares (i.e. for each cluster with \code{mean=}\eqn{((1+j d)/2,(1+j d)/2)} for \eqn{j=0,1,\ldots,k-1}
and the covariance matrix \eqn{sd I_2}, where \eqn{I_2} is the \eqn{2 \times 2} identity matrix.

Notice that the clusters are more separated, i.e., generated data indicates more clear clusters as \eqn{d} increases
in either positive or negative direction with \eqn{d=0} indicating one cluster in the data. For a fixed \eqn{d}, when \code{distribution="bvnormal"},
the clustering gets stronger if the variance of each component, \eqn{sd^2}, gets smaller, and clustering gets weaker
as the variance of each component gets larger where default is \eqn{sd=1/6}.
}
\examples{
n<-20  #or try sample(1:20,1);  #try also n<-50; n<-1000;
d<-.5 #try also -75,.75, 1
k<-3 #try also 5

#data generation
Xdat<-rdiag.clust(n,k,d)
Xdat

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#data generation (bvnormal)
n<-20  #or try sample(1:20,1);  #try also n<-50; n<-1000;
d<-.5 #try also -.75,.75, 1
k<-3 #try also 5
Xdat<-rdiag.clust(n,k,d,distr="bvnormal") #try also Xdat<-rdiag.clust(n,k,d,sd=.09,distr="bvnormal")
Xdat

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\seealso{
\code{\link{rhor.clust}} and \code{\link{rrot.clust}}
}
\author{
Elvan Ceyhan
}
