% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{seg.ind}
\alias{seg.ind}
\title{Dixon's Segregation Indices for NNCTs}
\usage{
seg.ind(ct, inf.corr = FALSE)
}
\arguments{
\item{ct}{A contingency table, in particular an NNCT}

\item{inf.corr}{A logical argument (default=\code{FALSE}). If \code{TRUE}, indices are modified so that 
they are finite and if \code{FALSE} the above definition in the description is used.}
}
\value{
Returns a \code{matrix} of segregation indices which is of the same dimension as \code{ct}.
}
\description{
Returns Dixon's segregation indices in matrix form based on entries of the NNCT, \code{ct}. 
Segregation index for cell \eqn{i,j} is defined as \eqn{log(N_{ii}(n-n_i)/((n_i-N_{ii})(n_i-1))} if \eqn{i=j}
and
as \eqn{log(N_{ij}(n-n_j-1)/((n_i-N_{ij})(n_j))} if \eqn{i \ne j}. 
See (\insertCite{dixon:NNCTEco2002,ceyhan:SiM-seg-ind2014;textual}{nnspat}).

The argument \code{inf.corr} is a logical argument (default=\code{FALSE}) to avoid \eqn{\pm \infty} for the segregation
indices. If \code{TRUE} indices are modified so that they are finite and if \code{FALSE} the above definition is used. 
(See \insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat} for more detail).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct
seg.ind(ct)
seg.ind(ct,inf.corr = TRUE)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

seg.ind(ct)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

seg.ind(ct)
seg.ind(ct,inf.corr = TRUE)

ct<-matrix(c(0,10,5,5),ncol=2)
seg.ind(ct)

seg.ind(ct,inf.corr = TRUE)

}
\seealso{
\code{\link{Pseg.coeff}}, \code{\link{seg.coeff}}, \code{\link{Zseg.ind}}
and \code{\link{Zseg.ind.ct}}
}
\author{
Elvan Ceyhan
}
