% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curry.R
\name{curry}
\alias{curry}
\alias{curry_fn}
\title{Curry a function}
\usage{
curry(f, env = environment(f))

curry_fn(..., ..env = parent.frame())
}
\arguments{
\item{f}{Function.}

\item{env}{Environment of the curried function or \code{NULL}. If \code{NULL}, the
environment of the curried function is the calling environment.}

\item{...}{Function declaration, which supports
\link[rlang:quasiquotation]{quasiquotation}.}

\item{..env}{Environment in which to create the function (i.e., the
function’s \link[base:environment]{enclosing environment}).}
}
\value{
A function of nested single-argument functions.
}
\description{
\code{curry()} \href{https://en.wikipedia.org/wiki/Currying}{curries} functions—it
reconstitutes a function as a succession of single-argument functions. For
example, \code{curry()} produces the the function\preformatted{function(x) \{
  function(y) \{
    function(z) \{
      x * y * z
    \}
  \}
\}
}

from the function \code{function(x, y, z) x * y * z}.
\cr\cr
\code{curry_fn()} produces a curried function from an \code{\link[=fn]{fn()}}-style function
declaration, which supports \link[rlang:quasiquotation]{quasiquotation} of a
function’s body and (default) argument values.
}
\details{
Dots (\code{...}) are treated as a unit when currying. For example,
\code{curry()} transforms \code{function(x, ...) list(x, ...)} to
\code{function(x) { function(...) list(x, ...) }}.
}
\examples{
curry(function(x, y, z = 0) x + y + z)
double <- curry(`*`)(2)
double(3)  # 6

curry_fn(x, y, z = 0 ~ x + y + z)
curry_fn(target, ... ~ identical(target, ...))

## Delay unquoting to embed argument values into the innermost function
compare_to <- curry_fn(target, x ~ identical(x, QUQ(target)))
is_this <- compare_to("this")
is_this("that")  # FALSE
is_this("this")  # TRUE
classify_as <- curry_fn(class, x ~ `class<-`(x, QUQ(class)))
as_this <- classify_as("this")
as_this("Some object")  # String of class "this"

}
\seealso{
\code{\link[=fn]{fn()}}
}
