% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/of.R
\name{of}
\alias{of}
\title{Occurence Frequency (OF) Measure}
\usage{
of(data)
}
\arguments{
\item{data}{data frame or matrix with cases in rows and variables in colums. Cases are characterized by nominal (categorical) variables coded as numbers.}
}
\value{
Function returns a matrix of the size \code{n x n}, where \code{n} is the number of objects in original data. The matrix contains proximities
between all pairs of objects. It can be used in hierarchical cluster analyses (HCA), e.g. in \code{\link[cluster]{agnes}}.
\cr
}
\description{
The OF (Occurrence Frequency) measure was originally constructed for the text mining,
see (Sparck-Jones, 1972), later, it was adjusted for categorical variables.
It assigns higher similarity to mismatches on less frequent values and otherwise.
Hierarchical clustering methods require a proximity (dissimilarity) matrix instead of a similarity matrix as
an entry for the analysis; therefore, dissimilarity \code{D} is computed from similarity \code{S} according the equation
\code{1/S-1}.\cr
\cr
}
\examples{
#sample data
data(data20)
# Creation of proximity matrix
prox_of <- of(data20)
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
\references{
Boriah, S., Chandola and V., Kumar, V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254. Available at:
 \url{ http://www-users.cs.umn.edu/~sboriah/PDFs/BoriahBCK2008.pdf}.
 \cr
 \cr
Spark-Jones, K. (1972). A statistical interpretation of term specificity and its application in retrieval.
In Journal of Documentation, 28(1), p. 11-21. Later: Journal of Documentation, 60(5) (2002), p. 493-502.
\cr
\cr
Sulc, Z. and Rezankova, H. (2014). Evaluation of recent similarity measures for categorical data.
In: AMSE. Wroclaw: Wydawnictwo Uniwersytetu Ekonomicznego we Wroclawiu, p. 249-258.
Available at: \url{http://www.amse.ue.wroc.pl/papers/Sulc,Rezankova.pdf}.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good3}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{morlini}},
\code{\link[nomclust]{sm}}.
}

