## ----eval=FALSE----------------------------------------------------------
#  install.packages('nonmemica')
#  library(nonmemica)

## ----echo=FALSE, results='hide'------------------------------------------
library(nonmemica)

## ----eval=FALSE----------------------------------------------------------
#  partab(1001, project='../model')

## ----eval=FALSE----------------------------------------------------------
#  options(project = '../model')
#  partab(1001)

## ----eval=FALSE----------------------------------------------------------
#  methods(format)

## ----eval=FALSE----------------------------------------------------------
#  partab(1001)

## ----eval=FALSE----------------------------------------------------------
#  1001 %>% partab

## ----eval=FALSE----------------------------------------------------------
#  2 %>% sqrt %>% signif(3)

## ----eval=FALSE----------------------------------------------------------
#  signif(sqrt(2),digits=3)

## ----eval=FALSE----------------------------------------------------------
#  partab(1001, xmlfile='..model/1001.xml')

## ----eval=FALSE----------------------------------------------------------
#  partab(1001, bootcsv='..model/1001/bootstrap_results.csv')

## ----eval=FALSE----------------------------------------------------------
#  partab(1001, ctlfile = '../models/1001.ctl',fields = c('symbol','label','unit')).

## ------------------------------------------------------------------------
library(magrittr)
library(nonmemica)
options(project = system.file('project/model',package='nonmemica'))
1001 %>% definitions %>% head

## ----eval = FALSE--------------------------------------------------------
#  1001 %>% definitions(write=T)
#  1001 %>% partab(ctlfile = NULL)

## ------------------------------------------------------------------------
partab(1001)

## ------------------------------------------------------------------------
x <- partab(1001)

## ----eval=FALSE----------------------------------------------------------
#  partab(1001, verbose=TRUE)

## ------------------------------------------------------------------------
1001 %>% partab(
  format = F, 
  ci = F, 
  relative = F, 
  digits = NULL
)

## ------------------------------------------------------------------------
library(knitr)
1001 %>% partab %>% kable

## ------------------------------------------------------------------------
library(pander)
1001 %>% partab %>% pander(justify='right')

