% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonical.R
\name{nms_nonmem.nms_pmx}
\alias{nms_nonmem.nms_pmx}
\title{Convert pmxTools Names to NONMEM}
\usage{
\method{nms_nonmem}{nms_pmx}(x, ...)
}
\arguments{
\item{x}{nms_pmx}

\item{...}{ignored}
}
\value{
nms_nonmem (character)
}
\description{
Converts nms_pmx to nms_nonmem.
I.e., THETA1 stays THETA1, but 
OM1,1 becomes OMEGA(1,1).
}
\examples{
library(magrittr)
c(
   'THETA1',
   'OM1,1',
   'OM1,2',
   'SG1,1',
   'SG1,2'
) \%>\%
as_nms_pmx \%>\%
nms_canonical
}
\seealso{
Other nms: 
\code{\link{as_nms_canonical}()},
\code{\link{as_nms_nonmem}()},
\code{\link{as_nms_pmx}()},
\code{\link{as_nms_psn}()},
\code{\link{nms_canonical.character}()},
\code{\link{nms_canonical.model}()},
\code{\link{nms_canonical.nms_nonmem}()},
\code{\link{nms_canonical.nms_pmx}()},
\code{\link{nms_canonical.numeric}()},
\code{\link{nms_canonical}()},
\code{\link{nms_nonmem.character}()},
\code{\link{nms_nonmem.model}()},
\code{\link{nms_nonmem.nms_canonical}()},
\code{\link{nms_nonmem.numeric}()},
\code{\link{nms_nonmem}()},
\code{\link{nms_pmx.nms_canonical}()},
\code{\link{nms_pmx.nms_nonmem}()},
\code{\link{nms_pmx}()},
\code{\link{nms_psn.character}()},
\code{\link{nms_psn.model}()},
\code{\link{nms_psn.numeric}()},
\code{\link{nms_psn}()}

Other nm: 
\code{\link{nms_canonical.nms_pmx}()},
\code{\link{nms_pmx.nms_nonmem}()}
}
\concept{nm}
\concept{nms}
