% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comma_cleaner.R
\name{comma_cleaner}
\alias{comma_cleaner}
\title{Title: Comma Cleaner function.}
\usage{
comma_cleaner(comma_df)
}
\arguments{
\item{comma_df}{A dirty data frame obtained from the FLUOstar DAT file.}
}
\value{
A clean data frame with numeric no-comma values for attribute(s).
}
\description{
This modular function, in the context of this package, is responsible for removing commas
from attribute(s) values. Removal of commas facilitates the conversion of attributes into the numeric class.
}
\examples{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- comma_cleaner(dat_df)
}
\seealso{
\code{\link[=clean_odd_cc]{clean_odd_cc()}}, \code{\link[=clean_odddat_optimus]{clean_odddat_optimus()}}
}
\author{
Tingwei Adeck
}
