% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_model.R
\name{download_model}
\alias{download_model}
\title{Download Model Fitted to the \code{novelforest} Data}
\usage{
download_model(save_to = NULL)
}
\arguments{
\item{save_to}{Path and name of the file where the R object is saved to.
Defaults to NULL, which does not save the model object locally.}
}
\value{
A \code{brms} model output of class \code{brmsfit},
which is a list containing the input \code{data} and other slots
that store the model components.
}
\description{
Download the \code{brms} model fitted to the \code{novelforest} data (Lai et al. 2021).
The model object is too large (16.5 MB) to be included with the package,
so the function downloads the model from the development GitHub website.
The generalised linear mixed-effect model was fitted via \code{brms::brm} so
this package is recommended to properly view the model object.
}
\examples{
novelforest_model <- download_model()

# library(brms)  # recommended
summary(novelforest_model)
}
\references{
Lai, H.R., Tan, G.S.Y., Neo, L., Kee, C.Y., Yee, A.T.K., Tan, H.T.W.
and Chong, K.Y. (2021) Decoupled responses of native and exotic tree
diversities to distance from old-growth forest and soil phosphorous in
novel secondary forests. \emph{Applied Vegetation Science}, 24, e12548.
\doi{10.1111/avsc.12548}
}
\seealso{
brms::brmsfit, brms::brm
}
