% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/month2qtr.R
\name{month2qtr}
\alias{month2qtr}
\title{Monthly to quarterly transformation}
\usage{
month2qtr(x, reference_month = 3)
}
\arguments{
\item{x}{a \code{ts} or \code{mts} in monthly frequency}

\item{reference_month}{a vector to define the reference month that will represent the quarter. Default is 3. The options are 1, 2, 3 or 'mean'.}
}
\value{
The correspondent quarterly transformation.
}
\description{
It transforms a monthly time series in a quarterly one, selecting the last month of the quarter to represent the value of the quarter.
}
\examples{
 \dontrun{
# Selecting only the last month of time series IPCA:
month2qtr(BRGDP$base[,"IPCA"], reference_month = 3)

# Selecting only the first month of time series IPCA:
month2qtr(BRGDP$base[,"IPCA"], reference_month = 1)
}
}
